/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: envelope.h,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/

#ifndef __qm_envelope_h__
#define __qm_envelope_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>
#include <quasimodo/function_tables.h>

/* this defines the maximum number of sections that the envelope can
   contain. The opcode description must match it by including
   MAXSECTION*2 'o' (OptionalDefaultsToZero) type descriptors at the
   end of the input type specification. NOTE: this places no limits on
   the complexity of the curve within the sections. It merely defines
   how many sections exist ie. the response of the envelope to
   trigger-like events that help to locate the correct section to use.  
*/

#define MAXSECTION 4
   
struct ENVSECTION {
    size_t first;
    size_t last;
};

OpcodeArgument(ENVELOPE)
    Number *out;
    Number *ifn;
    Number *idur;
    Number *ksection;
    Number *kamp;
    Number *args[MAXSECTION*2];

    RCPointer<FunctionTable> ftp;
    ENVSECTION *sections;
    DynamicMemory aux;
    size_t last_section;
    size_t current_section;
    Number section_offset;
    Number section_increment;
};

extern void envelope_set(ENVELOPE);
extern void envelope(ENVELOPE);

#define ENVELOPE_OPCODE_LIST \
{"envelope", S(ENVELOPE), InitTime|EventTime, "k", "Fikkjjjjjjjj", \
	 F(envelope_set), F(envelope), NULL }

#endif  __qm_envelope_h__
