#ifndef __dam_h__
#define __dam_h__

#include <quasimodo/opcode_defs.h>

#define POWER_BUFSIZE 1000

OpcodeArgument(DAM)
   Number *aout ;      /* Declare output array first  */
   Number *ain ;       /* Input array   */
   Number *kthreshold ;  /* sound level threshold */
   Number *icomp1 ;      /* Compression factors */
   Number *icomp2 ;
   Number *rtime ;	 /* Raise/Fall times */
   Number *ftime ;

   Number rspeed ;
   Number fspeed ;

   Number gain ;
   Number power ;
   Number powerBuffer[POWER_BUFSIZE] ;
   Number *powerPos ;

};

extern void daminit (DAM *p);
extern void dam (DAM *p);

#define DAM_OPCODE_LIST \
	{"dam", S(DAM), InitTime|AudioTime, "a", "akiiii", \
	    F(daminit), NULL, F(dam)}

#endif __dam_h__

