#ifndef __physmod_clarinet_h__
#define __physmod_clarinet_h__

/******************************************/
/*  Clarinet model ala Smith              */
/*  after McIntyre, Schumacher, Woodhouse */
/*  by Perry Cook, 1995-96                */
/*  Recoded for Csound by John ffitch     */
/*  November 1997                         */
/*                                        */
/*  This is a waveguide model, and thus   */
/*  relates to various Stanford Univ.     */
/*  and possibly Yamaha and other patents.*/
/*                                        */
/******************************************/

#include <quasimodo/opcode_defs.h>
#include "physutil.h"

/**********************************************/
/*  One break point linear reed table object  */
/*  by Perry R. Cook, 1995-96                 */
/*  Consult McIntyre, Schumacher, & Woodhouse */
/*        Smith, Hirschman, Cook, Scavone,    */
/*        more for information.               */
/**********************************************/

struct ReedTabl {
    Number	offSet;
    Number	slope;
    Number	lastOutput;
};

Number ReedTabl_LookUp(ReedTabl*, Number);

OpcodeArgument(CLARIN)
    Number	*ar;                  /* Output */
    Number	*amp, *frequency;
    Number	*reedStffns, *attack, *dettack, *noiseGain, *vibFreq;
    Number	*vibAmt, *ifn, *lowestFreq; 

    RCPointer<FunctionTable>	vibr;          /* Table for vibrato */
    Number	v_rate;         /* Parameters for vibrato */
    Number	v_time;
    DLineL	delayLine;
    ReedTabl	reedTable;
    OneZero	filter;
    Envelope	envelope;
    Noise	noise;
    int32	length;
    Number	outputGain;
    int32	kloop;
};

extern void clarinset(CLARIN *p);
extern void clarin(CLARIN *p);

#define CLARINET_OPCODE_LIST \
{"wgclar", S(CLARIN), InitTime|AudioTime, "a", "kkkiikkkio", \
	 F(clarinset), NULL, F(clarin), 0, "physutil" }


#endif __physmod_clarinet_h__
