/******************************************/
/*  Simple Brass Module Model ala     */
/*  Cook (TBone, HosePlayer)              */
/*  by Perry R. Cook, 1995-96             */
/*                                        */
/*  This is a waveguide model, and thus   */
/*  relates to various Stanford Univ.     */
/*  and possibly Yamaha and other patents.*/
/*                                        */
/*   Controls:    CONTROL1 = lipTension   */
/*                CONTROL2 = slideLength  */
/*		  CONTROL3 = vibFreq      */
/*		  MOD_WHEEL= vibAmt       */
/******************************************/

#ifndef __qm_brass_h__
#define __qm_brass_h__

#include <quasimodo/opcode_defs.h>
#include "physutil.h"

/**********************************************/
/*  Lip Filter Object by Perry R. Cook, 1995-96*/    
/*  The lip of the brass player has dynamics  */
/*  which are controlled by the mass, spring  */
/*  constant, and damping of the lip.  This   */
/*  filter simulates that behavior and the    */
/*  transmission/reflection properties as     */
/*  well.  See Cook TBone and HosePlayer      */
/*  instruments and articles.                 */
/**********************************************/

typedef BiQuad LipFilt;

void make_LipFilt(LipFilt*);
void LipFilt_clear(LipFilt*);
void LipFilt_setFreq(LipFilt*, Number frequency);
Number LipFilt_tick(LipFilt*, Number mouthSample,Number boreSample);
Number LipFilt_lastOut(LipFilt*);

OpcodeArgument(BRASS)
    Number	*ar;                  /* Output */
    Number	*amp, *frequency;
    Number	*liptension, *dettack;
    Number	*vibFreq, *vibAmt, *ifn, *lowestFreq; 

    RCPointer<FunctionTable>	vibr;          /* Table for vibrato */
    Number	v_rate;         /* Parameters for vibrato */
    Number	v_time;
    DLineA	delayLine;
    LipFilt	lipFilter;
    DCBlock	dcBlock;
    ADSR	adsr;
    int32	length;
    Number	slideTarget;
    Number	maxPressure;
    Number	lipTarget;
    Number	frq;            /* Remember previous value */
    Number	lipT;           /* and lip tension */
    int32	kloop;
};

void extern brassset(BRASS*);
void extern brass(BRASS*);

#define BRASS_OPCODE_LIST \
{"wgbrass", S(BRASS), InitTime|AudioTime, "a", "kkkikkio", \
	 F(brassset), NULL, F(brass), 0, "physutil" }

#endif __qm_brass_h__

