/******************************************/
/*  Bowed String model ala Smith          */
/* after McIntyre, Schumacher, Woodhouse  */
/*  by Perry Cook, 1995-96                */
/*  Recoded for Csound by John ffitch     */
/*  November 1997                         */
/*                                        */
/*  This is a waveguide model, and thus   */
/*  relates to various Stanford Univ.     */
/*  and possibly Yamaha and other patents.*/
/*                                        */
/******************************************/

#ifndef __qm_bowed_h__
#define __qm_bowed_h__

#include <quasimodo/opcode_defs.h>
#include "physutil.h"

/***********************************************/ 
/*  Simple Bow Table Object, after Smith       */
/*    by Perry R. Cook, 1995-96                */
/***********************************************/

struct BowTabl {
    Number	offSet;
    Number	slope;
    Number	lastOutput;
};

Number BowTabl_lookup(BowTabl*, Number sample);

OpcodeArgument(BOWED)
    Number	*ar;                  /* Output */
    Number	*amp, *frequency;
    Number	*bowPress, *betaRatio, *decay, *vibFreq;
    Number	*vibAmt, *ifn, *lowestFreq; 

    RCPointer<FunctionTable>	vibr;
    Number	v_rate;         /* Parameters for vibrato */
    Number	v_time;
    Number	v_phaseOffset;
    Number	v_lastOutput;
    DLineL	neckDelay;
    DLineL	bridgeDelay;
    BowTabl	bowTabl;
    OnePole	reflFilt;
    BiQuad	bodyFilt;
    ADSR	adsr;
    Number	maxVelocity;
    Number	baseDelay;
    Number	vibrGain;
    Number	lastpress;
    Number	lastfreq;
    Number	lastbeta;
    Number	lastamp;
    int32	kloop;
};
extern void bowedset(BOWED*);
extern void bowed(BOWED*);

#define BOWED_OPCODE_LIST \
{"wgbow", S(BOWED), InitTime|AudioTime, "a", "kkkkkkkio", \
	 F(bowedset), NULL, F(bowed), 0, "physutil" }

#endif __qm_bowed_h__
