/*
    Permission granted for GPL release by Hans Mikelson, April 1999

    Copyright (C) 1998-99 Hans Mikelson et al.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: biquad.h,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/

#ifndef __biquad_h__
#define __biquad_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/function_tables.h>
#include <quasimodo/dynamic_memory.h>

OpcodeArgument(BIQUAD)
    Number   *out, *in, *b0, *b1, *b2, *a0, *a1, *a2, *reinit;
    Number   xnm1, xnm2, ynm1, ynm2;
};

OpcodeArgument(MOOGVCF)
    Number   *out, *in, *fco, *res, *max;
    Number   xnm1, y1nm1, y2nm1, y3nm1, y1n, y2n, y3n, y4n;
    int16   fcocod, rezcod;
};

OpcodeArgument(REZZY)
    Number *out, *in, *fco, *rez, *mode;
    Number   xnm1, xnm2, ynm1, ynm2;
    int16   fcocod, rezcod;
};

OpcodeArgument(DISTORT)
    Number   *out, *in, *pregain, *postgain, *shape1, *shape2;
};

OpcodeArgument(VCO)
    Number   *ar, *xamp, *xcps, *wave, *pw, *sine, *maxd;
    Number   ynm1, ynm2, leaky;
    int16   ampcod, cpscod;
    int16     iphs;
    int32    lphs;
    RCPointer<FunctionTable> ftp;
    AUXCH   aux;
    int32    left;
};

OpcodeArgument(PLANET)
    Number   *outx, *outy, *outz, *mass1, *mass2, *sep, *xval, *yval, *zval;
    Number   *vxval, *vyval, *vzval, *delta, *fric;
    Number   s1z, s2z, friction;
    Number   x, y, z, vx, vy, vz, ax, ay, az, hstep;
};

OpcodeArgument(PAREQ)
    Number *out, *in, *fc, *v, *q, *mode;
    Number xnm1, xnm2, ynm1, ynm2, imode;
};

OpcodeArgument(NESTEDAP)
    Number   *out, *in, *mode, *maxdel, *del1, *gain1, *del2, *gain2;
    Number   *del3, *gain3, *istor;
    Number   *curp, out1, out2, out3;
    Number   *beg1p, *beg2p, *beg3p, *end1p, *end2p, *end3p;
    Number   *del1p, *del2p, *del3p;
    int32    npts;
    AUXCH   auxch;
};

OpcodeArgument(LORENZ)
    Number   *outx, *outy, *outz, *s, *r, *b, *hstep, *inx, *iny, *inz, *skip;
    Number   valx, valy, valz;
};

extern void biquadset (BIQUAD *p);
extern void biquad (BIQUAD *p);
extern void moogvcfset (MOOGVCF *p);
extern void moogvcf (MOOGVCF *p);
extern void rezzyset (REZZY *p);
extern void rezzy (REZZY *p);
extern void vcoset (VCO *);
extern void vco (VCO *);
extern void lorenzset (LORENZ *);
extern void lorenz (LORENZ *);
extern void nestedapset (NESTEDAP *);
extern void nestedap (NESTEDAP *);
extern void pareqset (PAREQ *);
extern void pareq (PAREQ *);
extern void planetset (PLANET *);
extern void planet (PLANET *);
extern void distort (DISTORT *);

#define BIQUAD_OPCODE_LIST \
{ "biquad", S(BIQUAD),   InitTime|AudioTime,     "a",    "aXXXXXXo", \
	  F(biquadset), NULL, F(biquad)  }, \
{ "moogvcf", S(MOOGVCF), InitTime|AudioTime,     "a",    "axxp", \
	  F(moogvcfset), NULL, F(moogvcf)  }, \
{ "rezzy", S(REZZY),     InitTime|AudioTime,     "a",    "axxo", \
	  F(rezzyset), NULL, F(rezzy)      }, \
{ "distort1", S(DISTORT), AudioTime,    "a",    "appoo", \
	  NULL,     NULL, F(distort)    }, \
{ "vco", S(VCO),         InitTime|AudioTime,     "a",    "XXiXFi", \
	  F(vcoset), NULL, F(vco)          }, \
{ "planet", S(PLANET),   InitTime|AudioTime,     "aaa",  "XXXiiiiiiio", \
	  F(planetset), NULL, F(planet)}, \
{ "pareq", S(PAREQ),     InitTime|AudioTime,     "a",    "aXXXXo", \
	  F(pareqset), NULL, F(pareq)      }, \
{ "nestedap", S(NESTEDAP), InitTime|AudioTime, "a", "aiiiiooooo", \
	  F(nestedapset), NULL, F(nestedap)}, \
{ "lorenz", S(LORENZ),   InitTime|AudioTime,   "aaa", "XXXXiiii", \
	  F(lorenzset), NULL, F(lorenz)    }
	
	
#endif __biquad_h__

