// ------------------------------------------------------------------------
// qeoperatorconfiguration.cpp: Input widget for configuring ecasound 
//                              operators
// Copyright (C) 2000 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <vector>
#include <string>

#include <qapplication.h>
#include <qaccel.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qhgroupbox.h>
#include <qvgroupbox.h>
#include <qhbox.h>
#include <qlineedit.h>
#include <qgrid.h>

#include "qeoperatorconfiguration.h"

/**
 * Class constructor
 */
QEOperatorConfiguration::QEOperatorConfiguration (OPERATOR* op, QWidget *parent, const char *name) 
  : QEInput(parent, name),
    operator_repp(op) {
  init_layout();
}

void QEOperatorConfiguration::init_layout(void) {

  QBoxLayout* top = new QVBoxLayout(this);

  QGroupBox* descgroup = new QHGroupBox(this, "descgroup");
  obj_name_repp = new QLabel("Name: ", descgroup, "name1");
  obj_name_repp = new QLabel(operator_repp->name().c_str(), descgroup, "name2");
  top->addWidget(descgroup);

  QGroupBox* descgroup2 = new QHGroupBox(this, "descgroup2");
  obj_desc_repp = new QLabel("Description: ", descgroup2, "desc1");
  obj_desc_repp = new QLabel(operator_repp->description().c_str(), descgroup2, "desc2");
  top->addWidget(descgroup2);

  paramlist_rep.resize(operator_repp->number_of_params());
  inputlist_rep.resize(operator_repp->number_of_params());
  suggestlist_rep.resize(operator_repp->number_of_params());
  paramgrid_repp = new QGrid(3, this);
  OPERATOR::PARAM_DESCRIPTION pardesc;
  for(int n = 0; n < operator_repp->number_of_params(); n++) {
    paramlist_rep[n] = new QLabel(QString::number(n + 1).leftJustify(12),paramgrid_repp);
    inputlist_rep[n] = new QLineEdit(paramgrid_repp);
    operator_repp->parameter_description(n + 1, &pardesc);
    QString lowbound = "n/a";
    QString highbound = "n/a";
    if (pardesc.bounded_below == true)
      lowbound = QString::number(pardesc.lower_bound);
    if (pardesc.bounded_above == true)
      highbound = QString::number(pardesc.upper_bound);
    suggestlist_rep[n] = new QLabel(" [" + 
				    lowbound + 
				    " -> " + 
				    highbound +
				    "] ", paramgrid_repp);
  }
  top->addWidget(paramgrid_repp);

  for(int n = 0; n < operator_repp->number_of_params(); n++) {
    paramlist_rep[n]->setText(QString(QString::number(n + 1) + 
				  QString(". ") + 
				  QString(operator_repp->get_parameter_name(n + 1).c_str())).leftJustify(12));
  }
  
  for(int n = operator_repp->number_of_params(); n < static_cast<int>(paramlist_rep.size()); n++) {
    paramlist_rep[n]->setText(QString(" - ").leftJustify(12));
  }
}

void QEOperatorConfiguration::update_results(void) {
  for(int n = 0; n < operator_repp->number_of_params(); n++) {
    operator_repp->set_parameter(n + 1, inputlist_rep[n]->text().toFloat());
  }
}

/** 
 * Initilizes a new operator object
 */
void QEOperatorConfiguration::change_operator(OPERATOR* op) {
  assert(op != 0);
  operator_repp = op;
  obj_name_repp->setText(operator_repp->name().c_str());
  obj_desc_repp->setText(operator_repp->description().c_str());

  int params_height = 0;
  OPERATOR::PARAM_DESCRIPTION pardesc;
  for(int n = 0; n < operator_repp->number_of_params(); n++) {
    if (n == static_cast<int>(paramlist_rep.size())) {
      paramlist_rep.push_back(new QLabel("", paramgrid_repp));
      inputlist_rep.push_back(new QLineEdit(paramgrid_repp));
      suggestlist_rep.push_back(new QLabel("", paramgrid_repp));
    }
    paramlist_rep[n]->setText(QString(QString::number(n + 1) + 
				  QString(". ") + 
				  QString(operator_repp->get_parameter_name(n + 1).c_str())).leftJustify(12));
    inputlist_rep[n]->setText(QString::number(operator_repp->get_parameter(n + 1)));
    operator_repp->parameter_description(n + 1, &pardesc);
    QString lowbound = "n/a";
    QString highbound = "n/a";
    if (pardesc.bounded_below == true)
      lowbound = QString::number(pardesc.lower_bound);
    if (pardesc.bounded_above == true)
      highbound = QString::number(pardesc.upper_bound);

    suggestlist_rep[n]->setText(" [" + 
				lowbound + 
				" -> " + 
				highbound +
				"] ");
    
    params_height += paramlist_rep.back()->height();

    inputlist_rep[n]->show();
    paramlist_rep[n]->show();
    suggestlist_rep[n]->show();
  }

  for(int n = operator_repp->number_of_params(); n <
	static_cast<int>(paramlist_rep.size()); n++) {
    inputlist_rep[n]->hide();
    paramlist_rep[n]->hide();
    suggestlist_rep[n]->hide();
  }

  updateGeometry();
}
