// ------------------------------------------------------------------------
// qeinterface.cpp: Top-level ecawave interface widget
// Copyright (C) 2000 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <ecasound/eca-version.h>

#include "qefile.h"
#include "qestatusbar.h"
#include "qesession.h"
#include "qeinterface.h"
#include "version.h"

QEInterface::QEInterface (const string& filename,
			  QWidget *parent, 
			  const char *name)
  : QMainWindow(parent, name) {

  setCaption(string("ecawave " +
		    ecawave_version + 
		    " . (C) 1999-2000 Kai Vehmanen . ").c_str());

  session_repp = new QESession(this, 
			       "session");
  QObject::connect(session_repp,
		   SIGNAL(new_session_request()),
		   this,
		   SLOT(new_session()));
  QObject::connect(session_repp,
		   SIGNAL(session_closed()),
		   this,
		   SLOT(close()));

  setCentralWidget(session_repp);

  if (filename.empty() != true) session_repp->open_file(filename);


}

QEInterface::~QEInterface(void) {
  while(child_interfaces_rep.size() > 0) {
    delete child_interfaces_rep.back();
    child_interfaces_rep.pop_back();
  }
}

void QEInterface::new_session(void) {
  child_interfaces_rep.push_back(new QEInterface());
  child_interfaces_rep.back()->show();
}
