.TH "ecasound" "1" "02\&.05\&.2000" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecasound \- sample editor, multitrack recorder, fx-processor, etc\&.
.PP 
.SH "SYNOPSIS" 
\fBecasound\fP [ general_options ] { [ chain_setup ] [ effect_setup ] [ input_setup ] [ output_setup ] }
.PP 
.SH "DESCRIPTION" 
.PP 
Ecasound is a software package designed for multitrack audio
processing\&. It can be used for simple tasks like audio playback, 
recording and format conversions, as well as for multitrack effect 
processing, mixing, recording and signal recycling\&. Ecasound supports 
a wide range of audio inputs, outputs and effect algorithms\&. Several
open-source audio packages, like for instance ALSA, OSS, mpg123, lame, 
libaudiofile and MikMod, are directly supported\&. One of the advantages 
of ecasound\'s chain-based design is that effects can easily be 
combined both in series and in parallel\&. Oscillators and MIDI-CCs 
can be used for controlling effect parameters\&. Included user-interfaces 
are ecasound - a versatile console mode interface, qtecasound - 
a Qt-based X-interface and various command-line utils suitable for 
batch processing\&.
.PP 
.SH "OPTIONS" 
.PP 
Notice that the order of parameters given on the command
line is important!
.PP 
\fBGLOBAL OPTIONS\fP
.IP 
.IP "-c" 
Starts ecasound in interactive mode\&. In interactive mode you can
control ecasound with simple commands ("start", "stop", "pause",
etc\&.)\&. See ecasound-iam(1)\&.
.IP 
.IP "-d:debug_level" 
Set the debug level to \'debug_level\'\&. This a bitmasked value, 
that defaults to 3\&. See ECA_DEBUG class documentation for 
more detailed info about various debug_level values\&.
.IP 
.IP "-q" 
Quiet mode, no output\&. Same as \fI-d:0\fP\&.
.IP 
.IP "--help" 
Show this help\&.
.IP 
.IP "--version" 
Print version info\&.
.IP 
.PP 
\fBCHAINSETUP OPTIONS\fP
.IP 
.IP "-n:name" 
Set the name of chainsetup to \'name\'\&. If not specified, defaults
either to "command-line-setup" or to the file name from which
chainsetup was loaded\&. Whitespaces are not allowed\&.
.IP 
.IP "-s[:]chainsetup-file" 
Create a new chainsetup from file \'chainsetup-file\' and add
it to the current session\&. Chainsetup can contain inputs, outputs, 
chains, effects, controllers, etc\&. A session, on the other hand, 
contains all the chainsetups\&. Although only one chainsetup can
be connected at a time, you can switch between them on-the-fly\&.
.IP 
.IP "-sr:sample_rate" 
Set internal sampling rate\&. This can be used to improve 
realtime performance or to avoid resampling\&. Default is 44100 
samples per second\&.
.IP 
.PP 
\fBGENERAL\fP
.IP 
.IP "-a:chainname1, chainname2, \&.\&.\&." 
Select active signal chains\&. All effects, inputs and outputs are assigned to
these chains\&. If there are no -a options given, default chain is used\&.
Chain name \'all\' is reserved and means that all chains are selected\&. By giving 
multiple -a options, you can control to which chains effects, inputs and outputs
are assigned to\&. Look at the 
\fBEXAMPLES\fP
section for more detailed info about the usage of this option\&.
.IP 
.IP "-b:buffer size" 
Sets the size of buffer in samples (must be an exponent of 2)\&. This
is quite an important option\&. For real-time processing, you should
set this as low as possible to reduce the processing delay\&. Some
machines can handle buffer values as low as 64 and 128\&. In some
circumstances (for instance when using oscillator envelopes) small
buffer sizes will make envelopes act more smoothly\&. When not processing
in real-time (all inputs and outputs are normal files), values between
512 - 4096 often give better results\&. Default is 1024\&.
.IP 
.IP "-m:mix-mode" 
Force ecasound to use mix mode \'mix_mode\'\&. \'auto\' = automatic (default),
\'simple\' =  only one input/chain/output, \'normal\' = normal single-threaded
mode and \'mthreaded\' = multithreaded mixing\&. In most cases, ecasound is 
able to find out the correct mode automatically\&.
.IP 
.IP "-r" 
Use realtime scheduling policy (SCHED_FIFO)\&. This is impossible if 
ecasound doesn\'t have root priviledges\&. Beware! This gives better 
performance, but can cause total lock-ups if something goes wrong\&.
.IP 
.IP "-x" 
Truncate outputs\&. If this isn\'t set, ecasound opens all outputs 
- if format allows it - in readwrite mode\&.
.IP 
.IP "-z:feature" 
Enable \'feature\'\&. \'db\' enables double-buffering for audio inputs 
that support it\&. \'psr\' enables the \fIprecise-sample-rates\fP mode 
for OSS-devices\&. See ecasoundrc(5)\&.
.IP 
.PP 
\fBPROCESSING CONTROL\fP
.IP "-t:seconds" 
Set processing time in seconds (doesn\'t have to be an integer value)\&.
If processing time isn\'t set, engine stops when all inputs are 
finished\&.
.IP 
.IP "-tl" 
Enable looping\&. When processing is finished, engine will start 
again from the initial position\&.
.IP 
.PP 
\fBINPUT/OUTPUT SETUP\fP
.PP 
See ecasound user\'s guide for 
more detailed documentation\&.
.PP 
.IP "-f:sample_format,channel,sample-rate" 
Set default sampling parameters\&. These are used for all following
input and output files or until another -f is specified\&. If no -f
option is present, ecasound uses s16_le/2ch/44100 as the default
value\&. Some audio objects may override this altogether (for instance, 
RIFF WAVE inputs and outputs)\&.
.IP 
Sample format is given as a a formatted string\&. The first letter is 
either "u", "s" and "f" (unsigned, signed, floating point)\&. The 
following number specifies sample size in bits\&. If sample is 
little endian, "_le" is added to the end\&. Similarly if big endian, 
"_be" is added\&. If endianess is not specified, host byte-order is used\&. 
Currently supported formats are "u8" (same as "8"), "s16_le" (same 
as "16"), "s16_be", "s24_le", "s24_be", "s32_le" and "s32_be"\&.
.IP 
.IP "-y:seconds" 
Set starting position for last specified input/output\&. If 
you need more flexible control over audio objects, you should
use the \fI\&.ewf\fP format\&.
.IP 
.IP "-i[:]input-file-or-device" 
Specifies a new input source that is connected to all selected chains\&.
Connecting multiple inputs to the same chain isn\'t possible\&. Input
can be a a file, device or some other audio object (see below)\&. 
If the input is a file, its type is determined using the file name 
extension\&. Currently supported formats are RIFF WAVE files (\&.wav), 
audio-cd tracks (\&.cdr), ecasound ewf-files (\&.ewf), RAW audio data
(\&.raw) and MPEG files (\&.mp2,\&.mp3)\&. Also, formats supported by the
SGI audiofile library: AIFF (\&.aiff, \&.aifc, \&.aif) and Sun/NeXT audio 
files (\&.au, \&.snd)\&. MikMod is also supported (\&.xm, \&.mod, \&.s3m, 
\&.it, etc)\&. Supported devices are OSS audio devices (/dev/dsp*),
ALSA audio and loopback devices (/dev/snd/pcm*, alsalb)\&. If no inputs 
are specified, the first non-option (doesn\'t start with \'-\') command
line argument is considered to be an input\&.
.IP 
.IP "-o[:]output-file-or-device" 
Works in the same way as the -i option\&. If no outputs are specified,
the default output device is used (see &tilde;/\&.ecasoundrc)\&. Note! 
you can\'t output to module formats supported by MikMod (this should
be obvious) nor to ALSA\'s loopback device\&.
.IP 
\fIOBJECT TYPE SPECIFIC NOTES\fP
.IP "ALSA devices" 
When using ALSA drivers, instead of a device filename, you need to
use the following option syntax: \fB-i[:]alsa,card_number,device_number\fP\&. 
If you need to specify individual subdevices:
\fB-i[:]alsa,card_number,device_number,subdevice_number\fP\&.
.IP 
.IP "ALSA pcm-plugin layer" 
Just like normal ALSA devices, but with automatic sample rate and format 
conversions\&. Option syntax is \fB-i[:]alsaplugin,card_number,device_number,subdevice_number\fP\&.
.IP 
.IP "ALSA loopback device" 
By using the ALSA loopback system, you can grab audio data from any
other pcm device\&. Option syntax is
\fB-i[:]alsalb,card_number,device_number,subdevice_number\fP\&.
.IP 
.IP "Ecasound Wave Files - \&.ewf" 
A simple wrapper class for handling other audio objects\&. 
See ecasound user\'s guide for more 
detailed information\&.
.IP 
.IP "Loop device" 
Loop devices make it possible to route data between chains\&.
Option syntax is \fB-[io][:]loop,id_number\fP\&. If you add a loop 
output with id \'1\', all data written to this output is routed
to all loop inputs with id \'1\'\&. You can attach the same loop
device to multiple inputs and outputs\&.
.IP 
.IP "Null inputs/outputs" 
If you specify "null" or "/dev/null" as the input or output, 
a null audio device is created\&. This is useful if you just want
to analyze sample data without writing it to a file\&.
.IP 
.IP "System standard streams and named pipes" 
You can use standard streams (stdin and stdout) by giving "stdin" 
or "stdout" as the file name\&. Audio data is assumed to be in
raw/headerless (\&.raw) format\&. If you want to use named pipes, 
create them with the proper file name extension before use\&.
.IP 
.PP 
\fBEFFECT SETUP\fP
.PP 
\fIPRESETS\fP
.PP 
Ecasound has a powerful effect preset system that allows you create
new effects by combining basic effects and controllers\&. See
ecasound user\'s guide for more 
detailed information\&.
.PP 
.IP 
.IP "-pf:preset_file\&.eep" 
Use the first preset found from file \'preset_file\&.eep\' as 
a chain operator\&.
.IP 
.IP "-pn:preset_name" 
Find preset \'preset_name\' from global preset database and use
it as a chain operator\&. See ecasoundrc(5) for info about the 
preset database\&.
.IP 
.PP 
\fISIGNAL ANALYSIS\fP
.PP 
.IP 
.IP "-ev" 
Analyze sample data to find out how much the signal can
be amplified without clipping\&. The resulting percent value
can be used as a parameter to -ea and -eas effects\&. Also prints 
a statistics table containing info about stereo-image and
how different sample values are used\&.
.IP 
.IP "-ezf" 
Find the optimal value for DC-adjusting\&. You can use the result
as a parameter to -ezx effect\&.
.IP 
.PP 
\fIGENERAL SIGNAL PROCESSING ALGORITHMS\fP
.IP "-ea:amplify-%" 
Amplifies signal by amplify-% percent\&. 
.IP 
.IP "-eac:amplify-%,channel" 
Amplifies signal of channel \'channel\' by amplify-% percent\&. \'channel\'
ranges from 1\&.\&.\&.n where n is the total number of channels\&.
.IP 
.IP "-eaw:amplify-%,max-clipped-samples" 
Amplifies signal by amplify-% percent\&. If number of consecutive
clipped samples (resulting sample has the largest amplitude
possible) reaches \'max-clipped-samples\', a warning will be issued\&.
.IP 
.IP "-ec:rate,threshold-%" 
Compressor (a simple one)\&. \'rate\' is the compression rate in
decibels (\'rate\' dB change in input signal causes 1dB change 
in output)\&. \'threshold\' varies between 0\&.0 (silence) and
1\&.0 (max amplitude)\&.
.IP 
.IP "-eca:peak-level-%, release-time-sec, fast-crate, crate" 
A more advanced compressor (original algorithm by John S\&. Dyson)\&. 
If you give a value of 0 to any parameter, the default is used\&.
\'peak-level-%\' essentially specifies how hard the peak limiter
is pushed\&.  The default of 69% is good\&. \'release_time\' is given 
in seconds\&. This compressor is very sophisticated, and actually
the release time is complex\&.  This is one of the dominant release 
time controls, but the actual release time is dependent on a lot of 
factors regarding the dynamics of the audio in\&. \'fastrate\' is the 
compression ratio for the fast compressor\&.  This is not really 
the compression ratio\&.  Value of 1\&.0 is infinity to one, while the 
default 0\&.50 is 2:1\&.  Another really good value is special cased in 
the code: 0\&.25 is somewhat less than 2:1, and sounds super smooth\&.
\'rate\' is the compression ratio for the entire compressor chain\&.  
The default is 1\&.0, and holds the volume very constant without many nasty
side effects\&.  However the dynamics in music are severely restricted,
and a value of 0\&.5 might keep the music more intact\&.
.IP 
.IP "-enm:threshold-level-%,pre-hold-time-msec,attack-time-msec,post-hold-time-msec,release-time-msec" 
Noise gate\&. Supports multichannel processing (each channel 
processed separately)\&. When signal amplitude falls below
\'threshold_level_%\' percent (100% means maximum amplitude), gate 
is activated\&. If the signal stays below the threshold for 
\'th_time\' ms, it\'s faded out during the attack phase of 
\'attack\' ms\&. If the signal raises above the \'threshold_level\' 
and stays there over \'hold\' ms the gate is released during 
\'release\' ms\&.
.IP 
.IP "-epp:right-%" 
Normal pan effect\&. Balance value of 0 means to pan signal fully
left and 100 fully right\&. If the panned signal is
a stereo signal, left and right channels aren\'t mixed together\&.
Use the -erm and -erc effects to force conversion to mono before 
panning\&.
.IP 
.IP "-ezx:left-dc-fix-value,right-dc-fix-value" 
Adjusts the signal DC by \'dc-fix-value\'\&. Use -ezf to find the
optimal value\&.
.IP 
.PP 
\fIFILTER EFFECTS\fP
.IP "-ef1:center_freq, width" 
Resonant bandpass filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-ef3:cutoff_freq, reso, gain" 
Resonant lowpass filter\&. \'cutoffr_freq\' is the filter cutoff
frequency\&. \'reso\' means resonance\&. Usually the best values for
resonance are between 1\&.0 and 2\&.0, but you can use even bigger values\&.
\'gain\' is the overall gain-factor\&. It\'s a simple multiplier (1\&.0 
is the normal level)\&. With high resonance values it often is useful 
to reduce the gain value\&.
.IP 
.IP "-ef4:cutoff, resonance" 
Resonant lowpass filter (3rd-order, 36dB)\&. Simulates 
an analog active RC-lowpass design\&. Cutoff is a value between [0,1],
while resonance is between [0,infinity)\&. 
.IP 
.IP "-efa:delay-samples,feedback-%" 
Allpass filter\&. Passes all frequencies with no change in amplitude\&.
However, at the same time it imposes a frequency-dependent 
phase-shift\&.
.IP 
.IP "-efc:delay-samples,radius" 
Comb filter\&. Allows the spikes of the comb to pass through\&.
Value of \'radius\' should be between [0, 1\&.0)\&.
.IP 
.IP "-efb:center-freq,width" 
Bandpass filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-efh:cutoff-freq" 
Highpass filter\&. Only frequencies above \'cutoff_freq\' are passed
through\&.
.IP 
.IP "-efi:delay-samples,radius" 
Inverse comb filter\&. Filters out the spikes of the comb\&. There
are \'delay_in_samples-2\' spikes\&. Value of \'radius\' should be 
between [0, 1\&.0)\&. The closer it is to the maximum value,
the deeper the dips of the comb are\&.
.IP 
.IP "-efl:cutoff-freq" 
Lowpass filter\&. Only frequencies below \'cutoff_freq\' are passed
through\&.
.IP 
.IP "-efr:center-freq,width" 
Bandreject filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-efs:center-freq,width" 
Resonator\&. \'center_freq\' is the center frequency\&. Width is specified
in Hz\&. Basicly just another resonating bandpass filter\&.
.IP 
.PP 
\fICHANNEL MIXING / ROUTING\fP
.IP 
.IP "-erc:from-channel, to-channel" 
Copy channel \'from_channel\' to \'to_channel\'\&. If \'to_channel\' 
doesn\'t exist, it is created\&. Channel indexing is started from 1\&.
.IP 
.IP "-erm:to-channel" 
Mix all channels to channel \'to_channel\'\&.  If \'to_channel\' 
doesn\'t exist, it is created\&. Channel indexing is started from 1\&.
.IP 
.PP 
\fITIME-BASED EFFECTS\fP
.IP 
.IP "-etc:delay-time-msec,variance-time-samples,feedback-%,lfo-freq" 
Chorus\&.
.IP 
.IP "-etd:delay-time-msec,surround-mode,number-of-delays,mix-%" 
Delay effect\&. \'delay time\' is the delay time in milliseconds\&.
\'surround-mode\' is a integer with following meanings: 0 = normal, 
1 = surround, 2 = stereo-spread\&. \'number_of_delays\' should be 
obvious\&. Beware that large number of delays and huge delay times 
need a lot of CPU power\&. \'mix-%\' determines how much effected (wet)
signal is mixed to the original\&.
.IP 
.IP "-etf:delay-time-msec" 
Fake-stereo effect\&. The input signal is summed to mono\&. The
original signal goes to the left channels while a delayed 
version (with delay of \'delay time\' milliseconds) is goes to
the right\&. With a delay time of 1-40 milliseconds this 
adds a stereo-feel to mono-signals\&. 
.IP 
.IP "-etl:delay-time-msec,variance-time-samples,feedback-%,lfo-freq" 
Flanger\&.
.IP 
.IP "-etm:delay-time-msec,number-of-delays,mix-%" 
Multitap delay\&. \'delay time\' is the delay time in milliseconds\&.
\'number_of_delays\' should be obvious\&. \'mix-%\' determines how much 
effected (wet) signal is mixed to the original\&.
.IP 
.IP "-etp:delay-time-msec,variance-time-samples,feedback-%,lfo-freq" 
Phaser\&.
.IP 
.IP "-etr:delay-time,surround-mode,feedback-%" 
Reverb effect\&. \'delay time\' is the delay time in milliseconds\&.
If \'surround-mode\' is \'surround\', reverbed signal moves around the
stereo image\&. \'feedback-%\' determines how much effected (wet)
signal is fed back to the reverb\&.
.IP 
.PP 
\fILADSPA-PLUGINS\fP
.IP "-el:plugin_unique_name,param-1,\&.\&.\&.,param-N" 
Ecasound supports LADSPA-effect plugins (Linux Audio Developer\'s Simple
Plugin API)\&. Plugins are located in shared library (\&.so) files in 
/usr/local/share/ladspa (configured in ecasoundrc(5))\&. One shared
library file can contain multiple plugin objects, but it is guaranteed 
that every plugin has a unique plugin name\&. This name is used
for selecting plugins\&. See LAD home page 
for more info about LADSPA\&.
.PP 
\fBGATE SETUP\fP
.PP 
.IP 
.IP "-gc:start-time,len" 
Time crop gate\&. Initially gate is closed\&. After \'start-time\' seconds
has elapse, gate opens and remains open for \'len\' seconds\&.
.IP 
.IP "-ge:open-threshold-%, close-thold-%,volume-mode" 
Threshold gate\&. Initially gate is closed\&. It is opened when volume 
goes over \'othreshold\' percent\&. After this, if volume drops below 
\'cthold\' percent, gate is closed and won\'t be opened again\&. 
If \'value_mode\' is \'rms\', average RMS volume is used\&. Otherwise
peak average is used\&. 
.IP 
.PP 
\fBCONTROL ENVELOPE SETUP\fP
.IP 
Controllers can be used to dynamically change effect parameters
during processing\&. All controllers are attached to the selected
(=usually the last specified effect/controller) effect\&. The first
three parameters are common for all controllers\&. \'fx_param\' 
specifies the parameter to be controlled\&. Value \'1\' means 
the first parameter, \'2\' the second and so on\&. \'start_value\' 
and \'end_value\' set the value range\&. You really should see
\fIexamples\&.html\fP for some more info\&. 
.IP 
.IP "-kos:fx-param,start-value,end-value,freq,i-phase" 
Sine oscillator with frequency of \'freq\' Hz and initial phase
of \'i_phase\' times pi\&.
.IP 
.IP "-kf:fx-param,start-value,end-value,freq,genosc-number" 
Generic oscillator\&. \'genosc_number\' is the number of the 
oscillator preset to be loaded\&. The location for the preset
file is taken from \&./ecasoundrc (see \fIecasoundrc(5)\fP)\&.
.IP 
.IP "-kl:fx-param,start-value,end-value,time-seconds" 
Linear envelope that starts from \'start_value\' and linearly 
changes to \'end_value\' during \'time_in_seconds\'\&. Can
be used for fadeins and fadeouts\&.
.IP 
.IP "-kl2:fx-param,start-value,end-value,1st-stage-length-sec,2nd-stage-length-sec" 
Two-stage linear envelope, a more versatile tool for doing fade-ins
and fade-outs\&. Stays at \'start_value\' for \'1st_stage_length\' seconds
and then linearly changes towards \'end_value\' during
\'2nd_stage_length\' seconds\&.
.IP 
.IP "-km:fx-param,start-value,end-value,controller,channel" 
MIDI continuous controller (control change messages)\&. 
Messages on the MIDI-channel \'channel\' that are coming from
controller number \'controller\' are used as the controller
source\&. The MIDI-device is specified in \&./ecasoundrc (see 
\fIecasoundrc(5)\fP)\&. Defaults to \fI/dev/midi\fP\&.
.IP 
.IP "-kx" 
This is a special switch that can be used when you need
to control controller parameters with another controller\&. 
When you specify \fI-kx\fP, the last specified controller 
will be set as the control target\&. Then you just add
another controller as usual\&. 
.PP 
\fBINTERACTIVE MODE\fP
.PP 
See \fIecasound-iam(1)\fP\&.
.PP 
.SH "FILES" 
.PP 
\fI~/\&.ecasoundrc\fP
The default ecasound resource file\&. See ecasoundrc(5)\&.
man page\&.
.PP 
\fI*\&.ews\fP 
Ecasound Wave Stats\&. These files are used to cache
waveform data\&. 
.PP 
\fI*\&.ecs\fP 
Ecasound Chainsetup files\&. Syntax is more or less the
same as with command-line arguments\&.
.PP 
.SH "SEE ALSO" 
.PP 
qtecasound(1),
ecatools(1), 
ecasound-iam(1)
ecasoundrc(5), 
"HTML docs in the Documentation subdirectory"
.PP 
.SH "BUGS" 
.PP 
See file BUGS\&. If ecasound behaves weirdly, try to
increase the debug level to see what\'s going on\&.
.PP 
.SH "AUTHOR" 
.PP 
Kai Vehmanen, <kaiv@wakkanet\&.fi>
.PP 
