#include <string>

#include <kvutils.h>

#include "midi-cc.h"
#include "ctrl_source.h"
#include "eca-midi.h"
#include "eca-debug.h"

double MIDI_CONTROLLER::value(void) {
  pthread_mutex_lock(&midi_in_lock);
  if (midi_in_queue.update_controller_value(controller,channel)) {
    value_rep = midi_in_queue.last_controller_value();
    //    cerr << "cc-value: " << value_rep;
    value_rep /= 127.0;
  }
  pthread_mutex_unlock(&midi_in_lock);
  return(value_rep);
}

string MIDI_CONTROLLER::label(void) {  return("MIDI-Controller/" + kvu_numtostr(controller)); }

MIDI_CONTROLLER::MIDI_CONTROLLER(int controller_number, int midi_channel) :
controller(controller_number), channel(midi_channel), value_rep(0.0)
{
    init_midi_queues();

    MESSAGE_ITEM otemp;
    otemp << "(midi-cc) MIDI controlled envelope created using controller ";
    otemp.setprecision(0);
    otemp << controller << " and channel " << channel << ".";
    ecadebug->msg(0, otemp.to_string());
}

double MIDI_CONTROLLER::get_parameter(int param) const { 
  switch (param) {
  case 1: 
    return((double)controller);
  case 2: 
    return((double)channel);
  }
}





