// ------------------------------------------------------------------------
// eca-chainop-map: Dynamic register for chain operator ids
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <vector>
#include <string>

#include "eca-chainop.h"
#include "audiogate.h"
#include "audiofx.h"
#include "audiofx_amplitude.h"
#include "audiofx_analysis.h"
#include "audiofx_filter.h"
#include "audiofx_mixing.h"
#include "audiofx_timebased.h"

#include "eca-chainop-map.h"

map<string, CHAIN_OPERATOR*> ECA_CHAINOP_MAP::chainop_map;
map<string, string> ECA_CHAINOP_MAP::chainop_prefix_map;

void ECA_CHAINOP_MAP::register_chain_operator(const string& id_string,
					     CHAIN_OPERATOR* chainop) {
  chainop->map_parameters();
  ECA_CHAINOP_MAP::chainop_map[id_string] = chainop;
  ECA_CHAINOP_MAP::chainop_prefix_map[chainop->name()] = id_string;
}

void ECA_CHAINOP_MAP::register_default_chainops(void) { 
  static bool defaults_registered = false;
  if (defaults_registered) return;
  defaults_registered = true;
  
  ECA_CHAINOP_MAP::register_chain_operator("ea", new EFFECT_AMPLIFY());
  ECA_CHAINOP_MAP::register_chain_operator("eac", new EFFECT_AMPLIFY_CHANNEL());
  ECA_CHAINOP_MAP::register_chain_operator("eaw", new EFFECT_AMPLIFY_CLIPCOUNT());
  ECA_CHAINOP_MAP::register_chain_operator("eca", new ADVANCED_COMPRESSOR());
  ECA_CHAINOP_MAP::register_chain_operator("ec", new EFFECT_COMPRESS());
  ECA_CHAINOP_MAP::register_chain_operator("ef1", new EFFECT_RESONANT_BANDPASS());
  ECA_CHAINOP_MAP::register_chain_operator("ef3", new EFFECT_RESONANT_LOWPASS());
  ECA_CHAINOP_MAP::register_chain_operator("efb", new EFFECT_BANDPASS());
  ECA_CHAINOP_MAP::register_chain_operator("efh", new EFFECT_HIGHPASS());
  ECA_CHAINOP_MAP::register_chain_operator("efi", new EFFECT_INVERSE_COMB_FILTER());
  ECA_CHAINOP_MAP::register_chain_operator("efl", new EFFECT_LOWPASS());
  ECA_CHAINOP_MAP::register_chain_operator("efr", new EFFECT_BANDREJECT());
  ECA_CHAINOP_MAP::register_chain_operator("efs", new EFFECT_RESONATOR());
  ECA_CHAINOP_MAP::register_chain_operator("enm", new EFFECT_NOISEGATE_MONO());
  ECA_CHAINOP_MAP::register_chain_operator("erc", new EFFECT_CHANNEL_COPY());
  ECA_CHAINOP_MAP::register_chain_operator("erm", new EFFECT_MIX_TO_CHANNEL());
  ECA_CHAINOP_MAP::register_chain_operator("epp", new EFFECT_NORMAL_PAN());
  ECA_CHAINOP_MAP::register_chain_operator("etd", new EFFECT_DELAY());
  ECA_CHAINOP_MAP::register_chain_operator("etf", new EFFECT_FAKE_STEREO());
  ECA_CHAINOP_MAP::register_chain_operator("etr", new EFFECT_REVERB());
  ECA_CHAINOP_MAP::register_chain_operator("ev", new EFFECT_ANALYZE());
  ECA_CHAINOP_MAP::register_chain_operator("ezf", new EFFECT_DCFIND());
  ECA_CHAINOP_MAP::register_chain_operator("ezx", new EFFECT_DCFIX());

  ECA_CHAINOP_MAP::register_chain_operator("gc", new TIME_CROP_GATE());
  ECA_CHAINOP_MAP::register_chain_operator("ge", new THRESHOLD_GATE());
}
