#ifndef _AUDIOFX_MIXING_H
#define _AUDIOFX_MIXING_H

#include <vector>

#include "samplebuffer_iterators.h"
#include "audiofx.h"

/**
 * Virtual base class for channel mixing and routing effects
 * @author Kai Vehmanen
 */
class EFFECT_MIXING : public EFFECT_BASE {
 public:
  typedef vector<parameter_type>::size_type ch_type;

  virtual ~EFFECT_MIXING(void) { }
};

/**
 * Channel copy (one-to-one copy)
 * @author Kai Vehmanen
 */
class EFFECT_CHANNEL_COPY : public EFFECT_MIXING {

private:

  ch_type from_channel, to_channel;
  SAMPLE_ITERATOR_CHANNEL f_iter, t_iter;

public:

  string name(void) { return("Channel copy"); }

  vector<string> parameter_names(void) const {
    vector<string> t;
    t.push_back("from-channel");
    t.push_back("to-channel");
    return(t);
  }

  int output_channels(int i_channels);

  void set_parameter(int param, parameter_type value);
  parameter_type get_parameter(int param) const;

  void init(SAMPLE_BUFFER *insample);
  void process(void);

  EFFECT_CHANNEL_COPY* clone(void)  { return new EFFECT_CHANNEL_COPY(*this); }
  EFFECT_CHANNEL_COPY (parameter_type from_channel = 1.0, parameter_type to_channel = 1.0);
};

/**
 * Channel copy (one-to-one copy)
 * @author Kai Vehmanen
 */
class EFFECT_MIX_TO_CHANNEL : public EFFECT_MIXING {

private:

  typedef vector<parameter_type>::size_type ch_type;

  int channels;
  ch_type to_channel;
  parameter_type sum;

  SAMPLE_ITERATOR_CHANNEL t_iter;
  SAMPLE_ITERATOR_INTERLEAVED i;

public:

  string name(void) { return("Mix to channel"); }

  vector<string> parameter_names(void) const {
    vector<string> t;
    t.push_back("to-channel");
    return(t);
  }

  int output_channels(int i_channels);

  void set_parameter(int param, parameter_type value);
  parameter_type get_parameter(int param) const;

  void init(SAMPLE_BUFFER *insample);
  void process(void);

  EFFECT_MIX_TO_CHANNEL* clone(void)  { return new EFFECT_MIX_TO_CHANNEL(*this); }
  EFFECT_MIX_TO_CHANNEL (parameter_type to_channel = 1.0);
};

#endif
