#include "eca-comhelp.h"

const char* ecasound_parameter_help_rep =
"USAGE: (qt)ecasound [options] \n"
"     -c                       set interactive mode \n"
"     -d:debug_level           show debug info \n"
"     -q                       quiet mode, no output "
"     -s[:]file                load chainsetup from 'file' \n"
" --- \n"
"     -b:buffersize            size of sample buffer in samples \n"
"     -m:mixmode               mixmode; auto (default), simple, normal, \n"
"                              mthreaded \n"
"     -n:name                  set chainsetup name \n"
"     -r                       raise runtime prioritary \n"
"     -sr:sample_rate          set internal sample rate \n"
"     -x                       truncate outputs \n"
"     -z:feature               enable feature 'feature' \n"
" --- \n"
"     -t:seconds               processing time in seconds \n"
"     -tl                      enable looping \n"
"     -tr                      enable return-to \n"
" --- \n"
"     -a:name1, name2, ...     select/create chains ('all' reserved) \n"
"     -f:type,channels,srate   default file format (for all following inputs/outputs) \n"
"     -i[:]infile              specify a new infile (assigned to active chains) \n"
"     -o[:]outfile             specify a new outfile (assigned to active chains) \n"
"     -y:seconds               set start position for last specified input/output \n"
" --- \n"
"     -ps:preset_name          insert a single-chain preset \n"
"     -ea:amplify_%            amplify_% (100% means no change) \n"
"     -eac:amplify_%,channel   amplify_%, channel is value between 0...n-1 \n"
"                              (n channels total)\n"
"     -eaw:amplify_%, cmax     amplify_% warns if over cmax consecutive\n"
"                              clipped samples \n"
"     -ec:c_rate,threshhold    compress (c_rate: -1.0 max. compress, 0.0 no \n"
"                              effect, >0.0 expand; doesn't affect if volume \n"
"                              under threshhold) \n"
"     -eca:peak-%, rel_time,   advanced compressor \n"
"      fastrate, crate          \n"
"     -ef1:center_freq, width  resonant bandpass filter \n"
"     -ef3:cutoff_freq, reso,  resonant lowpass filter \n"
"          gain \n"
"     -ef4:cutoff_freq, reso   resonant lowpass filter (2nd-order,24dB)\n"
"     -efb:center_freq,width   bandpass filter \n"
"     -efh:cutoff_freq         highpass filter \n"
"     -efi:delay_in_sampl,rad  inverse comb filter \n"
"     -efl:cutoff_freq         lowpass filter \n"
"     -efr:center_freq,width   bandreject filter \n"
"     -efs:center_freq,width   resonator filter \n"
"     -enm:threshold_level_%,  noise gate, mono \n"
"          th_time, attack,    ([0,1], ms, ms, ms, ms) \n"
"          hold, release        \n"
"     -erc:source,target       copy channel 'source' to 'target' \n"
"     -erm:target              mix all channels to channel 'target' \n"
"     -epp:l_r_balance         normal pan (0 = left, 100 = right) \n"
"     -etd:delay_time,mode,    delay (mode: 0 = normal,  \n"
"          number_of_delays    1 = surround, 2 = stereo-spread) \n"
"          mix_%%               \n"
"     -etf:delay_time          fake stereo (delay 1-40ms) \n"
"     -etr:reverb_time,mode,   reverb (mode: 0 = normal,  \n"
"         feedback_%%          1 = surround) \n"
"     -ev                      analyze/maximize volume (non-realtime) \n"
"     -ezf                     find optimal value for DC-fix \n"
"     -ezx:left,right          adjust DC \n"
" --- \n"
"     -gc:beg.time, len         time crop gate (gate open for 'len' seconds  \n"
"                               starting from 'beg.time') \n"
"     -ge:othreshold%, cthold%, threshold gate (open when volume goes over \n"
"         volume_mode           'othreshold' and closes when it drops below \n" 
"                               'cthold'. If 'value_mode' is 'rms', use \n"
"                               average RMS volume, otherwise use peak \n"
" --- \n"
"     -kos:fx_param,low_range,  sine-oscillator \n"
"          high_rng,freq,i_phase\n"
"     -kf:fx_param, low, high,  file envelope (generic oscillator) \n"
"         freq, gen-osc_number\n"
"     -kl:fx_param, low, high,  linear envelope (fade-in and fade-out)\n"
"         time_in_seconds\n"
"     -km:fx_param, low, high,  MIDI-controlled envelope\n"
"         controller, channel \n"
"\n\n";

const char* ecasound_parameter_help(void) {
  return(ecasound_parameter_help_rep);
}
