#include <string>

#include <kvutils.h>

#include "midi-cc.h"
#include "ctrl_source.h"
#include "eca-midi.h"
#include "eca-debug.h"

double MIDI_CONTROLLER::value(void) {
  return(midi_in_queue.get_controller_value(controller,channel) / 127.0);
}

string MIDI_CONTROLLER::label(void) {  return("MIDI-Controller/" + kvu_numtostr(controller)); }

MIDI_CONTROLLER::MIDI_CONTROLLER(int controller_number, int midi_channel) :
controller(controller_number), channel(midi_channel)
{
    init_midi_queues();

    support_for_dynamic_parameters(false);    

    MESSAGE_ITEM otemp;
    otemp << "(midi-cc) MIDI controlled envelope created using controller ";
    otemp.setprecision(0);
    otemp << controller << " and channel " << channel << ".";
    ecadebug->msg(0, otemp.to_string());
}

double MIDI_CONTROLLER::get_parameter(int param) const { 
  switch (param) {
  case 1: 
    return((double)controller);
  case 2: 
    return((double)channel);
  }
}




