#ifndef _ECA_QT_WAVEDATA_H
#define _ECA_QT_WAVEDATA_H

#include <vector>
#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qvgroupbox.h>

#include <sys/types.h>

#include "audioio.h"
#include "samplebuffer.h"

class QEWaveBlock {
 public:
  int16_t min[SAMPLE_BUFFER::ch_count];
  int16_t max[SAMPLE_BUFFER::ch_count];
};

class QEWaveData : public QWidget
{
public:
  QEWaveData(AUDIO_IO_DEVICE* iodevice, QWidget *parent=0, const char *name=0 );

  void updateWaveData(bool force = false);
  bool is_valid(void) { return(valid_iodevice); }

  void set_buffersize(int value) { buffersize = value; } 

  void set_wave_color(const QColor& value) { wave_color = value; }
  void set_background_color(const QColor& value) { background_color = value; }
  void set_position_color(const QColor& value) { position_color = value; }
  void set_minmax_color(const QColor& value) { position_color = value; }
  void set_zeroline_color(const QColor& value) { position_color = value; }

protected:

  void paintEvent( QPaintEvent * );
  void timerEvent( QTimerEvent * );

private:

  int waveblock_maximum(int channel, int from, int step);
  int waveblock_minimum(int channel, int from, int step);
  void calculate_buffersize(void);

  void load_ews_data(void);
  void save_ews_data(bool forced = false);

  void load_ews_data_ascii(void);
  void save_ews_data_ascii(void);


  QRect ur;
  QPixmap pix;
  QPainter p;

  QColor wave_color, 
         background_color,
         position_color,
         minmax_color,
         zeroline_color;

  AUDIO_IO_DEVICE* iodevice;
  int buffersize;

  int samples_per_pixel;
  int xposcoord, newxposcoord;
  int step;
  vector<QEWaveBlock>::size_type t;
  int xcoord;
  int ycoord;
  int waveheight;
  int buffersize_save;

  bool valid_iodevice;
  vector<QEWaveBlock> waveblocks; 
};

#endif


