#ifndef _ECA_AUDIOPOSITION_H
#define _ECA_AUDIOPOSITION_H

class ECA_AUDIOPOSITION {

 private:

  long int position_in_samples_rep;
  long int length_in_samples_rep;

 public:

  // --
  // Simple iterators
  // --
  void first(void);
  void last(void);

  // --
  // Get length
  // --
  inline long length_in_samples(void) const { return(length_in_samples_rep); }
  int length_in_seconds(void) const;
  double length_in_seconds_exact(void) const;

  // --
  // Set length
  // --
  void length_in_samples(long pos);
  void length_in_seconds(int pos_in_seconds);
  void length_in_seconds(double pos_in_seconds);
  virtual void length_in_samples_hook(void) { } 

  // --
  // Get position
  // --
  long position_in_samples(void) const;
  int position_in_seconds(void) const;
  double position_in_seconds_exact(void) const;

  // --
  // Set position
  // --
  void position_in_samples(long pos, bool seek = false);
  void position_in_seconds(int pos_in_seconds, bool seek = false);
  void position_in_seconds(double pos_in_seconds, bool seek = false);
  virtual void position_in_samples_hook(void) { } 

  ECA_AUDIOPOSITION(void);
};

#endif

