// ------------------------------------------------------------------------
// gcontroller.cpp: General sources for control signals.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <cmath>
#include <string>

#include <kvutils.h>

#include "eca-chainop.h"
#include "ctrl_source.h"
#include "gcontroller.h"

#include "eca-debug.h"

void GCONTROLLER::update(void) {
  new_value = ctrl_source->value();

  new_value = new_value * fabs(rangehigh - rangelow);
  new_value += rangelow;
  
  //  ecadebug->msg(2, "Setting new parameter value... to " + kvu_numtostr(new_value) + ".");
  cop->set_parameter(param_id, new_value);
}

GCONTROLLER::GCONTROLLER(CHAIN_OPERATOR* afx, CONTROLLER_SOURCE* csrc, char par_id, double range_low, double range_high) {

  cop = afx;
  ctrl_source = csrc;
  param_id = par_id;
  rangelow = range_low;
  rangehigh = range_high;

  ecadebug->msg("(gcontroller) Created a new general controller; chainop \"" +
		afx->name() + "\" source \"" + csrc->label() + "\" param number " +
		kvu_numtostr((int)par_id) + " range from " + 
		kvu_numtostr(range_low) + " to " + 
		kvu_numtostr(range_high) + ".");
}


