#ifndef _AUDIOFX_ANALYSIS_H
#define _AUDIOFX_ANALYSIS_H

#include <vector>
#include <string>

#include "samplebuffer.h"
#include "audiofx.h"

/**
 * Virtual base for signal analyzers.
 * @author Kai Vehmanen
 */
class EFFECT_ANALYSIS : public EFFECT_BASE {

 public:

  void set_parameter(int param, parameter_type value) { }
  parameter_type get_parameter(int param) const { return(0.0); }

  vector<string> parameter_names(void) const { vector<string> t; return(t); }

  virtual ~EFFECT_ANALYSIS(void) { }
};

/**
 * Effect for analyzing sample volume.
 * @author Kai Vehmanen
 */
class EFFECT_ANALYZE : public EFFECT_ANALYSIS {

  int nm;
  unsigned long int num_of_samples[SAMPLE_BUFFER::ch_count]; // number of samples processed
  unsigned long int ranges[16][SAMPLE_BUFFER::ch_count];     // tyyliin ... -32768->30720 ... 30719->32767
  parameter_type max;
  
 public:

  parameter_type max_multiplier(void) const;
    
  string name(void) { return("Volume-analyze"); }
    
  void process(SAMPLE_BUFFER::sample_type *insample);
  string status(void);
  
  EFFECT_ANALYZE* clone(void)  { return new EFFECT_ANALYZE(*this); }
  EFFECT_ANALYZE (const EFFECT_ANALYZE& x);
  EFFECT_ANALYZE (void);
  ~EFFECT_ANALYZE (void);
};

/**
 * Calculates DC-offset.
 * @author Kai Vehmanen
 */
class EFFECT_DCFIND : public EFFECT_ANALYSIS {

private:

  parameter_type pos_sum[SAMPLE_BUFFER::ch_count], neg_sum[SAMPLE_BUFFER::ch_count];
  parameter_type num_of_samples[SAMPLE_BUFFER::ch_count];

  SAMPLE_BUFFER::single_type tempval;
  
  unsigned short int nm;  // temp value (channel)

public:

  parameter_type get_deltafix(int channel);
    
  string name(void) { return("DC-Find"); }

  string status(void);
  void process(SAMPLE_BUFFER::sample_type *insample);

  EFFECT_DCFIND* clone(void)  { return new EFFECT_DCFIND(*this); }
  EFFECT_DCFIND (const EFFECT_DCFIND& x);
  EFFECT_DCFIND (void);
};

#endif
