#ifndef _AUDIOFX_H
#define _AUDIOFX_H

#include <vector>

#include "samplebuffer.h"
#include "eca-chainop.h"

/**
 * Virtual base for all audio effect classes.
 * @author Kai Vehmanen
 */
class EFFECT_BASE : public CHAIN_OPERATOR {

 public:
  virtual ~EFFECT_BASE(void) { }
};

/**
 * Adjusts DC-offset.
 * @author Kai Vehmanen
 */
class EFFECT_DCFIX : public EFFECT_BASE {

private:

  SAMPLE_BUFFER::single_type deltafix[SAMPLE_BUFFER::ch_count];
  unsigned short int nm;  // temp value (channel)

public:

  string name(void) { return("DC-Fix"); }

  vector<string> parameter_names(void) const {
    vector<string> t;
    t.push_back("delta-value-left");
    t.push_back("delta-value-right");
    return(t);
  }

  void set_parameter(int param, parameter_type value);
  parameter_type get_parameter(int param) const;

  void process(SAMPLE_BUFFER::sample_type *insample);

  EFFECT_DCFIX* clone(void)  { return new EFFECT_DCFIX(*this); }
  EFFECT_DCFIX (const EFFECT_DCFIX& x);
  EFFECT_DCFIX (parameter_type delta_left = 0.0, parameter_type delta_right = 0.0);
};

#endif
