#ifndef _ECA_MAIN_H
#define _ECA_MAIN_H

#include <vector>
#include <string>
#include <ctime>
#include <pthread.h>

#include <kvutils.h>

#include "samplebuffer.h"

class AUDIO_IO;
class ECA_SESSION;
class CHAIN;
class CHAIN_OPERATOR;
class ECA_CHAINSETUP;

extern COMMAND_QUEUE ecasound_cqueue;

class ECA_PROCESSOR {

private:

  ECA_SESSION* eparams;
  pthread_t chain_thread;

  bool finished_result;
  
  bool rt_infiles, rt_outfiles;
  
  string st_info_string;
  bool end_request;

  // ---
  // Pointers to active chainsetup
  // ---
  ECA_CHAINSETUP* csetup;
  vector<AUDIO_IO*>* inputs;
  vector<AUDIO_IO*>* outputs;
  vector<CHAIN*>* chains;

  vector<int> input_chain_count;
  vector<int> output_chain_count;

  int input_count, output_count, chain_count;

  double current_position(void) const; // seconds, uses the master_input
  void set_position(double seconds);
  void set_position(int seconds) { set_position((double)seconds); }
  void change_position(int seconds);

  void start(void);
  void stop(void);
    
  void interprete_cqueue(void);

  void init_status_variables(void);
  void init_mix_method(void);
  void init_pointers(void);

  void mix_to_chains(void);
  void mix_from_chains(void);

  bool is_chain_enabled(const string& name);
  void enable_chain(const string& cname);
  void disable_chain(const string& cname);

  void multitrack_sync(void);

  void exec_normal_iactive(void);
  void exec_normal_passive(void);
  void exec_simple_iactive(void);
  void exec_simple_passive(void);
  void exec_mthreaded_iactive(void);
  void exec_mthreaded_passive(void);
  bool finished(void);

  typedef vector<AUDIO_IO*>::const_iterator audio_ci;
  typedef vector<SAMPLE_BUFFER>::const_iterator audioslot_ci;
  typedef vector<CHAIN*>::const_iterator chain_ci;
  typedef vector<CHAIN*>::iterator chain_i;
  typedef vector<CHAIN_OPERATOR*>::const_iterator chainop_ci;

 public:

  void exec(void);
  void init(void);

  ECA_PROCESSOR(ECA_SESSION* eparam);
  ~ECA_PROCESSOR(void);

 private:

  ECA_PROCESSOR& operator=(const ECA_PROCESSOR& x) { return *this; }
};

void *mthread_process_chains(void* ecaparams);

#endif






