#ifndef _CHAINOP_H
#define _CHAINOP_H

#include <map>
#include <string>

#include "dynamic-parameters.h"
#include "samplebuffer.h"

/**
 * Virtual base class for chain operators. 
 * @author Kai Vehmanen
 */
class CHAIN_OPERATOR : public DYNAMIC_PARAMETERS {
 
 public:

  /**
   * Chain operator name.
   */
  virtual string name(void) = 0;

  /**
   * Process sample data
   * @param sbuf pointer to a sample buffer object
   */
  virtual void process(SAMPLE_BUFFER* sbuf) {
    sbuf->first();
    while(sbuf->is_readable()) {
      process(sbuf->current_sample());
      sbuf->next();
    }
  }

  /**
   * Process sample data one sample at a time
   * @param single_sample pointer to a single sample
   */
  virtual void process(SAMPLE_BUFFER::sample_type* single_sample) { };

  /**
   * Optional status info.
   * @param single_sample pointer to a single sample
   */
  virtual string status(void) { return(""); }

  /**
   * Virtual method that clones the current object and returns 
   * a pointer to it. This must be implemented by all subclasses!
   */
  virtual CHAIN_OPERATOR* clone(void) = 0;

  /**
   * Virtual destructor.
   */
  virtual ~CHAIN_OPERATOR (void) { }

  //  CHAIN_OPERATOR (void) { }
};

#endif






