// ------------------------------------------------------------------------
// resource-file.cpp: Class for representing resource files.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <map>
#include <string>
#include <cstdlib>
#include <fstream>

#include <kvutils.h>

#include "resource-file.h"
#include "eca-debug.h"

RESOURCE_FILE::~RESOURCE_FILE(void) {
  if (changed_rep ||
      (loaded_resource_values != -1 && 
       loaded_resource_values != rcmap.size())) save();
}

void RESOURCE_FILE::load(void) {
  ifstream fin (res_file.c_str());

  if (!fin) return;

  string first, second;
  string comment;
  int count = 0;

  while(fin >> first) {
    if (first.size() > 0 && first[0] == '#') {
      comment = first;
      while(fin.eof() == false) {
	int t = fin.get();
	comment += string(1, (char)t);
	if (t == '\n') break;
      }
      rc_comments[count] += comment;
      //      cerr << "(resource-file) Added commment \""
      //	+ comment + "\" to index number " 
      //	+ kvu_numtostr(count) << ".\n";
    }
    else { 
      fin >> second;
      if (second == "=") {
	use_equal_sign = true;
	fin >> second;
      }
      if (!fin.eof()) {
	rcmap[first] = second;
	++count;
	//	cerr << "(resource-file) Added resource-pair \"" 
	//	  + first + "\" = \"" + second + "\".\n";
      }
      while(fin.get() != '\n' && !fin.eof());
    }
  }
  loaded_resource_values = rcmap.size();
  changed_rep = false;
  fin.close();
}
 
void RESOURCE_FILE::save(void) {
  ofstream fout (res_file.c_str());
  if (!fout) return;

  map<string,string>::const_iterator p = rcmap.begin();
  map<int,string>::const_iterator q;
  int count = 0;
  while(p != rcmap.end()) {
    q = rc_comments.begin();
    while (q != rc_comments.end()) {
      if (q->first == count) {
	fout << q->second;
	break;
      }
      ++q;
    }
    if (use_equal_sign)
      fout << p->first << " = " << p->second << "\n";
    else
      fout << p->first << " " << p->second << "\n";
    ++p;
    ++count;
  }

  q = rc_comments.begin();
  while (q != rc_comments.end()) {
    if (q->first == count) {
      fout << q->second;
      break;
    }
    ++q;
  }

  fout.close();
}

const string& RESOURCE_FILE::resource(const string& tag) {
  return(rcmap[tag]); 
}

void RESOURCE_FILE::resource(const string& tag, const string& value) {
  changed_rep = true;
  rcmap[tag] = value;
}

