// ------------------------------------------------------------------------
// audiofx.cpp: Generel effect processing routines.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <cmath>

#include <kvutils.h>

#include "samplebuffer.h"
#include "audiofx.h"
#include "eca-debug.h"
#include "eca-error.h"

EFFECT_DCFIX::EFFECT_DCFIX (DYNAMIC_PARAMETERS::parameter_type delta_left, DYNAMIC_PARAMETERS::parameter_type delta_right) {
  // map_parameters();

  deltafix[SAMPLE_BUFFER::ch_left] = delta_left;
  deltafix[SAMPLE_BUFFER::ch_right] = delta_right;
}

EFFECT_DCFIX::EFFECT_DCFIX (const EFFECT_DCFIX& x) {
  for(nm = 0; nm < SAMPLE_BUFFER::ch_count; nm++) {
    deltafix[nm] = x.deltafix[nm];
  }
}

void EFFECT_DCFIX::set_parameter(int param, DYNAMIC_PARAMETERS::parameter_type value) {
  switch (param) {
  case 1: 
    deltafix[SAMPLE_BUFFER::ch_left] = value;
    break;
  case 2: 
    deltafix[SAMPLE_BUFFER::ch_right] = value;
    break;
  }
}

DYNAMIC_PARAMETERS::parameter_type EFFECT_DCFIX::get_parameter(int param) const { 
  switch (param) {
  case 1: 
    return(deltafix[SAMPLE_BUFFER::ch_left]);
  case 2: 
    return(deltafix[SAMPLE_BUFFER::ch_right]);
  }
  return(0.0);
}

void EFFECT_DCFIX::process(SAMPLE_BUFFER::sample_type *insample) {
  for(nm = 0; nm < SAMPLE_BUFFER::ch_count; nm++)
    insample->put_channel(nm, (insample->get_channel(nm) + deltafix[nm]));
}
