#ifndef _AUDIOIO_CDR_H
#define _AUDIOIO_CDR_H

#include <string>
#include "samplebuffer.h"

typedef struct {
  public:
  int16_t sample[2]; // signed short int
} SAMPLE;

/**
 * Represents a CDR -file. 
 * 
 * <br>CDR -format is the format used in audio-CDs:
 *    <ul>
 *    <li> 16bit samples, 44100kHz, stereo
 *    <li> one sample is coded: (MSB-left, LSB-left, MSB-right, LSB-right)
 *    <li> samples are coded in sectors (2352 bytes)
 *    </ul>
 * @author Kai Vehmanen
 */
class CDRFILE : public AUDIO_IO_FILE {

  static const int sectorsize = 2352;

  long int samples_read;

  FILE* fobject;
  void pad_to_sectorsize(void);
  void set_length_in_bytes(void);

  CDRFILE(const CDRFILE& x) { }
  CDRFILE& operator=(const CDRFILE& x) { return *this; }

  void position_in_samples_hook(void);
  unsigned short swapw(unsigned short us) { return ((us >> 8) | (us << 8)) & 0xffff;  }

  void swap_bytes(SAMPLE* t) {
    if (format().bits == 16) {
      t->sample[SAMPLE_BUFFER::ch_left] = swapw(t->sample[SAMPLE_BUFFER::ch_left]);
      t->sample[SAMPLE_BUFFER::ch_right] = swapw(t->sample[SAMPLE_BUFFER::ch_right]);
    }
  }
    
 public:

  void read_buffer(SAMPLE_BUFFER* t);
  void write_buffer(SAMPLE_BUFFER* t);

  void open_device(void);
  void close_device(void);
    
  CDRFILE (const string& name, const SIMODE mode, const AIO_PARAMS& format, int bsize);
  CDRFILE::~CDRFILE(void);
    
  CDRFILE* clone(void) { return new CDRFILE(*this); }    
};

#endif









