#ifndef _AUDIOIO_ALSALB_H
#define _AUDIOIO_ALSALB_H

#include <config.h>
#ifdef COMPILE_ALSA

#include <string>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/asoundlib.h>

#include "samplebuffer.h"

class ALSALBDEVICE : public AUDIO_IO_DEVICE {
//
// Class for handling ALSA -devices (Advanced Linux Sound Architecture).
//
// ---

#if SND_LIB_VERSION<769    // if alsa-lib older than 0.3.1
  typedef snd_pcm_t void*;
#endif

  snd_pcm_loopback_t *audio_fd;

  int card_number, device_number;
  bool pb_mode;

  int fragment_size;
  long int bytes_read;

  bool is_triggered;
  
 public:

  void open_device(void);
  void close_device(void);

  void get_sample(SAMPLE_BUFFER* t);
  void put_sample(SAMPLE_BUFFER* t) { }
 
  // --
  // Realtime related functions
  // --
  
  inline bool is_realtime(void) const { return(true); }
  
  ALSALBDEVICE (int card, int device, const SIMODE mode, const
		AIO_PARAMS& form, int buffersize, 
		bool playback_mode = true);
  ALSALBDEVICE::~ALSALBDEVICE(void);
  ALSALBDEVICE* clone(void) { return new ALSALBDEVICE(*this); }
  
 private:
  
  ALSALBDEVICE(const ALSALBDEVICE& x) { }
  ALSALBDEVICE& operator=(const ALSALBDEVICE& x) { return *this; }
};

#endif // COMPILE_ALSA
#endif
