#ifndef _AUDIOIO_ALSA_H
#define _AUDIOIO_ALSA_H

#include <config.h>
#ifdef COMPILE_ALSA

#include <string>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/asoundlib.h>

#include "samplebuffer.h"

class ALSADEVICE : public AUDIO_IO_DEVICE {
//
// Class for handling ALSA -devices (Advanced Linux Sound Architecture).
//
// ---

#if SND_LIB_VERSION<769    // if alsa-lib older than 0.3.1
  typedef snd_pcm_t void*;
#endif

  snd_pcm_t *audio_fd;

  //  static int (ALSADEVICE::*snd_pcm_open)(snd_pcm_t **,int,int,int);

  int card_number, device_number;

  int fragment_size;
  long int bytes_read;

  bool is_triggered;
  
 public:

  void open_device(void);
  void close_device(void);

  void   get_sample(SAMPLE_BUFFER* t);
  void   put_sample(SAMPLE_BUFFER* t);
 
  // --
  // Realtime related functions
  // --
  
  inline bool is_realtime(void) const { return(true); }

  void rt_stop(void);
  void rt_ready(void);
  void rt_activate(void);
 
  ALSADEVICE (int card, int device, const SIMODE mode, const AIO_PARAMS& form, int buffersize);
  ALSADEVICE::~ALSADEVICE(void);
  ALSADEVICE* clone(void) { return new ALSADEVICE(*this); }
  
 private:
  
  ALSADEVICE(const ALSADEVICE& x) { }
  ALSADEVICE& operator=(const ALSADEVICE& x) { return *this; }

};

#endif // COMPILE_ALSA
#endif



