.TH "ecasoundrc" "5" "07\&.09\&.1999" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecasoundrc \- ecasound rcfile
.PP 
.SH "SYNOPSIS" 
$HOME/\&.ecasoundrc
.PP 
.SH "DESCRIPTION" 
.PP 
\fBecasoundrc\fP is the main configuration file for ecasound\&. 
If it doesn\'t exist, ecasound creates it with default 
values\&. If it exists, all name-value pairs are read\&. When 
you quit ecasound, \fBecasoundrc\fP is rewritten if resource
values have been modified\&.
.PP 
The format is quite simple\&. One line consists of 
a configuration variable and a value\&. Variable and value 
are separated with whitespace\&. You can also use \'=\' 
sign as the separator, but be sure to surround it with
white space\&. Line "name = some_value" is valid, but 
"name=some_value" isn\'t\&. Lines beginning with a "#" 
are ignored (comment lines)\&. 
.PP 
.SH "VARIABLES" 
.PP 
.IP 
.IP "midi-device" 
MIDI-device\&. If the device name is given in \fI/dev/midi*\fP 
format, OSS/Linux os OSS/Lite drivers are used\&. 
Device \fI/dev/snd/midiCxDy\fP opens an ALSA raw-MIDI 
device with card number \'x\' and device number \'y\'\&. 
Defaults to \fI/dev/midi\fP\&.
.IP 
.IP "default-output" 
Output device to use\&. Defaults to \fI/dev/dsp\fP\&.
.IP 
.IP "default-buffersize" 
Sets the size of buffer in samples (must be an exponent of 2)\&.
Same as the \fB-b\fP command line options\&. Defaults to \fI1024\fP\&.
.IP 
.IP "default-to-interactive-mode" 
Whether to always use interactive mode (true or false)\&. Same as the
the \fB-c\fP command line option\&. Defaults to \fIfalse\fP\&. 
.IP 
.IP "default-to-raisepriority" 
Whether to always raise runtime priority (true or false)\&. Same as the
the \fB-r\fP command line option\&. Defaults to \fIfalse\fP\&. 
.IP 
.IP "default-to-double-buffering" 
Whether to used advanced double-buffering with audio inputs
that support it\&. Defaults to \fIfalse\fP\&.
.IP 
.IP "resource-directory" 
Directory for ecasound configuration files\&. 
Defaults to \fI/etc/ecasound\fP\&.
.IP 
.IP "resource-file-genosc-envelopes" 
Configuration file for generic oscillators\&. Is located in the 
resource directory\&. Defaults to \fIgeneric_oscillators\fP\&.
.IP 
.IP "resource-file-single-effect-presets" 
Configuration file for single-chain effect presets\&. Is located in the 
resource directory\&. Defaults to \fIsinglechain_effect_presets\fP\&.
.IP 
.IP "resource-file-multi-effect-presets" 
Configuration file for single-chain effect presets\&. Is located in the 
resource directory\&. Defaults to \fImultichain_effect_presets\fP\&.
.IP 
.IP "x-wave-editor" 
Command line for executing an external wave editor\&. Defaults
to \fIsnd\fP\&.
.IP 
.IP "x-text-editor-use-getenv" 
Should ecasound try to use value of environment variable
"EDITOR" or executing an external text editor\&. Defaults 
to \fItrue\fP\&.
.IP 
.IP "x-default-text-editor" 
If \fIx-text-editor-use-getenv\fP is \fIfalse\fP or "EDITOR" 
in null, value of this field is used\&. Defaults to \fIemacs\fP\&.
.IP 
.PP 
.SH "SEE ALSO" 
.PP 
ecasound(1), qtecasound (1), ecatools (1)
.PP 
.SH "AUTHOR" 
.PP 
Kai Vehmanen, <kaiv@wakkanet\&.fi>
.PP 
