// ------------------------------------------------------------------------
// audioio.cpp: Routines common for all audio IO-devices.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <string>

#include <kvutils.h>

#include "error.h"
#include "audioio.h"
#include "samplebuffer.h"


const string AUDIO_IO_DEVICE::format_info(void) const {
  
  MESSAGE_ITEM otemp;

  otemp  << "(audio-io) Channels " << (int)format().channels;
  otemp << ", srate " << format().srate;
  otemp << ", bits " << (int)format().bits;
  otemp << ", align " << format().align;
  otemp << ", bytes second " << format().byte_second;
  otemp << ".";
  
  return(otemp.to_string());
}

const string AUDIO_IO_DEVICE::status(void) const {
  if (is_realtime()) {
    return("realtime-device.");
  }
  else {
    MESSAGE_ITEM mitem;
    mitem << "position (" << position_in_seconds();
    mitem << "/" << length_in_seconds();
    mitem << ") seconds.";
    return(mitem.to_string());
  }
}



