// ------------------------------------------------------------------------
// qlistview_dumb.cpp: A re-implementation of Qt widget QListView. 
//                     Changes the way key presses are handled.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include "qlistview-dumb.h"

QListView_dumb::QListView_dumb( QWidget * parent = 0, const char *name
				= 0 )
  : QListView(parent, name) { }

void QListView_dumb::keyPressEvent( QKeyEvent * e )
{
    if ( !e )
        return; // subclass bug

    QListViewItem* oldCurrent = currentItem();
    if ( !oldCurrent )
        return;

    QListViewItem * i = currentItem();

    if ( isMultiSelection() && i->isSelectable() && e->ascii() == ' ' ) {
        setSelected( i, !i->isSelected() );
	//        d->currentPrefix.truncate( 0 );
        return;
    }

    QRect r( itemRect( i ) );
    QListViewItem * i2;

    bool singleStep = FALSE;

    switch( e->key() ) {
    case Key_Enter:
    case Key_Return:
      //        d->currentPrefix.truncate( 0 );
        if ( i && !i->isSelectable() &&
            ( i->childCount() || i->isExpandable() || i->isOpen() ) ) {
            i->setOpen( !i->isOpen() );
            return;
        }
        e->ignore();
        emit returnPressed( currentItem() );
        // do NOT accept.  QDialog.
        return;
    case Key_Down:
        i = i->itemBelow();
	//        d->currentPrefix.truncate( 0 );
        singleStep = TRUE;
        break;
    case Key_Up:
        i = i->itemAbove();
	//       d->currentPrefix.truncate( 0 );
        singleStep = TRUE;
        break;
    case Key_Home:
        i = firstChild();
	//        d->currentPrefix.truncate( 0 );
        break;
    case Key_End:
        i = firstChild();
        while ( i->nextSibling() )
            i = i->nextSibling();
        while ( i->itemBelow() )
            i = i->itemBelow();
	//        d->currentPrefix.truncate( 0 );
        break;
    case Key_Next:
        i2 = itemAt( QPoint( 0, visibleHeight()-1 ) );
        if ( i2 == i || !r.isValid() ||
             visibleHeight() <= itemRect( i ).bottom() ) {
            if ( i2 )
                i = i2;
            int left = visibleHeight();
            while( (i2 = i->itemBelow()) != 0 && left > i2->height() ) {
                left -= i2->height();
                i = i2;
            }
        } else {
            i = i2;
        }
	//        d->currentPrefix.truncate( 0 );
        break;
    case Key_Prior:
        i2 = itemAt( QPoint( 0, 0 ) );
        if ( i == i2 || !r.isValid() || r.top() <= 0 ) {
            if ( i2 )
                i = i2;
            int left = visibleHeight();
            while( (i2 = i->itemAbove()) != 0 && left > i2->height() ) {
                left -= i2->height();
                i = i2;
            }
        } else {
            i = i2;
        }
	//        d->currentPrefix.truncate( 0 );
        break;
    case Key_Plus:
        if (  !i->isOpen() && (i->isExpandable() || i->childCount()) )
            setOpen( i, TRUE );
	//        d->currentPrefix.truncate( 0 );
        break;
//      case Key_Right:
//          if ( i->isOpen() && i->childItem )
//              i = i->childItem;
//          else if ( !i->isOpen() && (i->isExpandable() || i->childCount()) )
//              setOpen( i, TRUE );
//          else if ( contentsX() + visibleWidth() < contentsWidth() )
//              horizontalScrollBar()->addLine();
//  	//        d->currentPrefix.truncate( 0 );
//          break;
    case Key_Minus:
        if ( i->isOpen() )
            setOpen( i, FALSE );
	//        d->currentPrefix.truncate( 0 );
        break;
    case Key_Left:
        if ( i->isOpen() )
            setOpen( i, FALSE );
	//        else if ( i->parentItem && i->parentItem != d->r )
	//            i = i->parentItem;
        else if ( contentsX() )
            horizontalScrollBar()->subtractLine();
	//        d->currentPrefix.truncate( 0 );
        break;
    case Key_Space:
      //      i->activate();
      //      i->setSelected(true);
	//        d->currentPrefix.truncate( 0 );
      break;
    case Key_Escape:
        e->ignore(); // For QDialog
        break;
    default:
        e->ignore(); // For the _dumb :)
        break;
    }

    if ( !i )
        return;

      if ( i->isSelectable() &&
           ((e->state() & ShiftButton) || !isMultiSelection()) )
	setSelected( i, true );
	//          setSelected( i, d->currentSelected
        //                       ? d->currentSelected->isSelected()
//                       : TRUE );

    setCurrentItem( i );
    //    if ( singleStep )
    //        d->visibleTimer->start( 1, TRUE );
    //    else
        ensureItemVisible( i );
}




