#ifndef _ECA_QTINTE_H
#define _ECA_QTINTE_H

#include <qapplication.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qstatusbar.h>

#include "eca-qtrtposition.h"
#include "eca-session.h"
#include "eca-controller.h"

class QEInterface : public QWidget
{
  Q_OBJECT
public:
  QEInterface(ECA_CONTROLLER* control, const ECA_SESSION* session, QWidget *parent=0, const char *name=0 );

protected:
  void keyPressEvent(QKeyEvent*  kevent);
  void timerEvent( QTimerEvent * );
  //  void resizeEvent( QResizeEvent * );

public slots:
  void emsg_general(void);
  void emsg_exec(void);
  void emsg_quit(void);
  void emsg_start(void);
  void emsg_stop(void);
  void emsg_forward(void);
  void emsg_rewind(void);
  void emsg_rw_begin(void);
  void emsg_status(void);
  void emsg_estatus(void);
  void emsg_fstatus(void);
  void emsg_cstatus(void);
  void emsg_setpos(double pos_seconds);

private slots:
  void init_signallevel(void);
  void init_sessionsetup(void);
  void update_statusbar(void);
  void update_qtbuttons(void);
  void not_implemented(void);

signals:
  void is_finished(void);
  void clear_textinput(void);
  void update_signallevel(int);
  void mute_signallevels(void);

private:
  QLineEdit* tekstirivi;
  QStatusBar* statusbar;
  QERuntimePosition* rpos;

  const ECA_SESSION* ecaparams;
  ECA_CONTROLLER* ctrl;

  void init_statusbar(void);
  void init_qtbuttons(QBoxLayout* buttons);
  void init_bottomrow(QBoxLayout* bottomrow);
  void init_buttons(QBoxLayout* buttons);
  void init_textinput(QBoxLayout* textinput);
  void init_debugout(QBoxLayout* debugout);
};

#endif


