// ------------------------------------------------------------------------
// eca-qtchain: Qt widget representing a CHAIN object and its state.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <string>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#include "chain.h"
#include "eca-controller.h"

#include "qlistview-dumb.h"
#include "eca-qtchain.h"

QEChain::QEChain(ECA_CONTROLLER* control, const CHAIN* ch, QWidget *parent, const char *name )
        : QWidget( parent, name ), ctrl(control), chain(ch)
{
  setMinimumSize( 600, 200 );

  startTimer(5000);
  
  QString caption = "qtecasound - chain: " + QString(ch->cname().c_str());
  setCaption(caption);

  QBoxLayout* topLayout = new QVBoxLayout( this );
  buttons = new QHBoxLayout();

  init_chainlist();

  init_buttons();

  topLayout->addLayout(buttons, 1);
  topLayout->addWidget(chainview, 0, 0);
}

void QEChain::not_implemented(void) {
  QMessageBox* mbox = new QMessageBox(this, "mbox");
  mbox->information(this, "qtecasound", "This feature is not implemented...",0);
}

void QEChain::init_buttons(void) {
  QFont butfont ("Helvetica", 12, QFont::Normal);

  QPushButton* quit = new QPushButton( "(Q)uit", this, "quit" );
  quit->setFont(butfont);
  buttons->addWidget( quit, 1, 0);

  QPushButton* ffocus = new QPushButton( "(F)ocus to list", this, "ffocus" );
  ffocus->setFont(butfont);
  buttons->addWidget( ffocus, 1, 0);

  QObject::connect( ffocus, SIGNAL(clicked()), chainview,
		    SLOT(setFocus()));
  QObject::connect( quit, SIGNAL(clicked()), this, SLOT(close()));
  //  connect(quit, SIGNAL(clicked()), this, SLOT(emsg_quit()) );
}

void QEChain::init_chainlist (void) {

  chainview = new QListView_dumb(this, "chainview");

  //  chainsetupview->setMaximumSize( width() / 2, height() / 2);
  chainview->setMinimumSize( 600, 100 );
       
  chainview->addColumn("Operator");  
  chainview->addColumn("Params");

  chainview->setAllColumnsShowFocus( TRUE ); 

  update_chainlist();

  int pixelsleft = width();
  for(int n = 1; n < 2; n++) 
    pixelsleft -= chainview->columnWidth(n);
  
  if (pixelsleft > 0) {
    chainview->setColumnWidthMode(0, QListView::Manual);
    chainview->setColumnWidth(0, pixelsleft);
  }
  chainview->setGeometry(0, 0, width(), 100);

  chainview->show();
}

void QEChain::update_chainlist (void) {
  QListViewItem* selected = chainview->selectedItem();
  QString selname = ""; 
  if (selected != 0) selname = selected->text(0);

  chainview->clear();

  vector<CHAIN_OPERATOR*>::const_iterator p = chain->chainops.begin();
  while(p != chain->chainops.end()) {
    QListViewItem* newitem = new QListViewItem(chainview,
					       (*p)->label().c_str(),
					       "");
    if (newitem->text(0) == selname) chainview->setSelected(newitem, true);
    ++p;
  }

  chainview->triggerUpdate();
}

void QEChain::keyPressEvent(QKeyEvent* kevent) {
  switch(tolower(kevent->ascii())) {

  case 'f': 
    {
      chainview->setFocus();
      break;
    }

  case 'q': 
    {
      close();
      break;
    }

  }
  kevent->ignore();
}

void QEChain::timerEvent( QTimerEvent * ) {
  update_chainlist();
}
