#ifndef _AUDIOIO_AF_H
#define _AUDIOIO_AF_H

#include <config.h>
#ifdef COMPILE_AF

#include <string>
#include <audiofile.h>

#include "audioio.h"
#include "samplebuffer.h"

class AUDIOFILE_INTERFACE : public AUDIO_IO_DEVICE {
//
// Interface to SGI audiofile library. 
//

    long curpos_in_samples, length_samples;
    AFfilehandle afhandle;
    //    bool is_little_endian;

    AUDIOFILE_INTERFACE& operator=(const AUDIOFILE_INTERFACE& x) { }
    void debug_print_type(void);

 public:
    
    void   get_sample(SAMPLE_BUFFER* t);
    void   put_sample(SAMPLE_BUFFER* t);
    void   first(void);
    void   last(void);

    inline bool is_realtime(void) const { return(false); }
    
    long   length_in_samples(void) const;
    long   position_in_samples(void) const;
    void   position_in_samples(long pos);
    
    AUDIOFILE_INTERFACE* clone(void) { return new AUDIOFILE_INTERFACE(*this); }
    
    AUDIOFILE_INTERFACE (const string& name, const SIMODE mode, const
			 AIO_PARAMS& form, int bsize);
    ~AUDIOFILE_INTERFACE(void);
};

#endif
#endif

