#ifndef _ECA_CONTROLLER_H
#define _ECA_CONTROLLER_H

#include <pthread.h>

#include "eca-session.h"

#define ECASOUND_LOCK_FILE "/var/lock/ecasound.lck"

enum {
  ECA_QUIT = 1
};

class ECA_CONTROLLER {

  ECA_SESSION* session; 
  int retcode;
  pthread_t th_cqueue;
  bool show_prompt;

 public:

  void command(const string& cmd);

  void load_chainsetup(const string name);
  void save_chainsetup(const string name);

  void print_general_status(void);
  void print_chain_status(void);
  void print_effect_status(void);
  void print_file_status(void);
  bool prompt(void);

  void close_engine(void);
  void start_engine(bool ignore_lock = false);
  void quit(void);

  ECA_CONTROLLER (ECA_SESSION* psession);
};

void show_controller_help(void);
void show_controller_help_more(void);

void start_normal_thread(ECA_SESSION* param, int retcode, pthread_t* th_cqueue);
void* start_normal(void* param);
void start_normal(ECA_SESSION* param);

#endif

