#ifndef _AUDIOIO_ALSA_H
#define _AUDIOIO_ALSA_H

#include <config.h>
#ifdef COMPILE_ALSA

#include <string>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/asoundlib.h>

#include "samplebuffer.h"

class ALSADEVICE : public AUDIO_IO_DEVICE {
//
// Class for handling ALSA -devices (Advanced Linux Sound Architecture).
//
// ---

  snd_pcm_t *audio_fd;

  int card_number, device_number;

  //  audio_buf_info audiobuf;          // soundcard.h
  //  count_info audioinfo;             // soundcard.h
  //  fd_set fds;
  //  struct timeval tv;
  int fragment_size;

  bool is_open;
  bool is_triggered;
  int buffersize;
  
  void open_device(void);
  void close_device(void);
  
    public:

  void   get_sample(SAMPLE_BUFFER* t);
  void   put_sample(SAMPLE_BUFFER* t);
  
  void first(void) { }
  void last(void) { }
  
  // --
  // Realtime related functions
  // --
  
  inline bool is_realtime(void) const { return(true); }

  void rt_stop(void);
  void rt_ready(void);
  void rt_activate(void);
  
  long   length_in_samples(void) const { return(0); }
  long   position_in_samples(void) const { return(0); }
  void   position_in_samples(long pos) { }
  
  ALSADEVICE (int card, int device, const SIMODE mode, const AIO_PARAMS& form, int buffersize);
  ALSADEVICE::~ALSADEVICE(void);
  ALSADEVICE* clone(void) { return new ALSADEVICE(*this); }
  
 private:
  
  ALSADEVICE(const ALSADEVICE& x) { }
  ALSADEVICE& operator=(const ALSADEVICE& x) { }

};

#endif // COMPILE_ALSA
#endif

