// ------------------------------------------------------------------------
// com_line.cpp: A wrapper class for parsing command line arguments.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <string>
#include <vector>

// #include "debug.h"
#include "com_line.h"

COMMAND_LINE::COMMAND_LINE(int argc, char *argv[]) {
    current = 0;

//    cerr << "Pekrle!" << argc << "\n";
    for(int t = 0; t < argc; t++) {
        cparams.push_back(argv[t]);
//        cerr << "\n Pekrle! :" << argv[t];
	//        debug.msg(2, "added command line parameter",cparams.back());
    }
}

COMMAND_LINE::COMMAND_LINE(const vector<string>& params) {

  //    debug.msg(1, "going to add a vector of size ",(int)params.size());    
//    for(vector<string>::const_size_type n; n < params.size(); n++) {
//        cparams.push_back(params[n]);
//        debug.msg(2, "added command line parameter",cparams.back());
    //    }
    cparams = params;
    //    debug.msg(1, "after adding... a vector of size ",(int)cparams.size());
}

const string& COMMAND_LINE::next_argument(void) {
    while (current < cparams.size()) {
        ++current;
        if (cparams[current - 1].at(0) == '-') return(cparams[current - 1]);
    }
    return(*new string(""));
}

const string& COMMAND_LINE::next_non_argument(void) {
    while (current < cparams.size()) {
        ++current;
        if (cparams[current - 1].at(0) != '-') return(cparams[current - 1]);
    }
    return(*new string(""));
}

const string& COMMAND_LINE::next(void) {
    if (ready() == false) return(*new string(""));
    ++current;    
    return(cparams[current - 1]);
}

const string& COMMAND_LINE::previous(void) {
    --current;
    if (ready() == false) return(*new string(""));
    if (current > 0) return(cparams[current - 1]);
    else return(*new string(""));
}










