#ifndef _ECA_ERROR_H
#define _ECA_ERROR_H

#define ECA_ERROR_EVERYTHING_OK             0
#define ECA_ERROR_UNABLE_TO_OPEN_FILE       1
#define ECA_ERROR_INVALID_PARAMETRES        2
#define ECA_ERROR_INVALID_RIFF_HEADER       3
#define ECA_ERROR_UNABLE_TO_ALLOCATE_MEMORY 4
#define ECA_ERROR_NO_RIFF_FMT_BLOCK_FOUND   5
#define ECA_ERROR_NO_RIFF_DATA_BLOCK_FOUND  6
#define ECA_ERROR_UNKNOWN_FORMAT            7
#define ECA_ERROR_INVALID_PARAMETRE_FILE    8
#define ECA_ERROR_INVALID_OUTPUT_FORMAT     9
#define ECA_ERROR_GENERAL_SBUF_ERROR       10

#define ECA_ERROR_UNABLE_TO_OPEN_OSS_DEVICE                          50
#define ECA_ERROR_AUDIO_FORMAT_NOT_SUPPORTED_BY_OSS_DEVICE           51
#define ECA_ERROR_AUDIO_FORMAT_STEREO_NOT_SUPPORTED_BY_OSS_DEVICE    52
#define ECA_ERROR_AUDIO_FORMAT_SRATE_NOT_SUPPORTED_BY_OSS_DEVICE     53
#define ECA_ERROR_GENERAL_OSS_ERROR                                  54

#define ECA_ERROR_GATE_ERROR                                         60

#define ECA_ERROR_ENVELOPE_UNABLE_TO_OPEN_MIDI_DEVICE                70
    
#define ECA_ERROR_DART_GENERAL            127
#define ECA_ERROR_DART_UNABLE_TO_DEVICE   128

#include <string>

void virhe(int virhe, const char *aihe);

enum ACTION { stop, retry, proceed };

class ECA_ERROR {
    
private:
    string esection;
    string eerrormsg;

    ACTION eaction;

public:

    virtual const string& error_section(void) { return(esection); }
    virtual const string& error_msg(void) { return(eerrormsg); }
    virtual const ACTION& error_action(void) { return(eaction); }
    
    ECA_ERROR(const string& section, const string& errormsg, const ACTION& action) {
        esection = section;
        eerrormsg = errormsg;
        eaction = action;
    }
    ECA_ERROR(const string& section, const string& errormsg) {
        esection = section;
        eerrormsg = errormsg;
	eaction = stop;
    }

    virtual ~ECA_ERROR(void) { }
};

#endif
