// ------------------------------------------------------------------------
// audiofx_timebased.cpp: Routines for time-based effects.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <string>

#include <kvutils.h>

#include "audiofx.h"

EFFECT_DELAY::EFFECT_DELAY (double delay_time, const string& surround_mode, int num_of_delays) {
    laskuri = 0.0;
    dtime = delay_time;
    if (surround_mode == "surround") 
      surround = 1;
    else if (surround_mode == "stereo-spread") 
      surround = 2;
    else
      surround = 0;

    dnum = (double)num_of_delays;

    if (dnum == 0) dnum = 1;
    if (dtime == 0) dtime = 1;

    buffer = new SINGLE_BUFFER[dnum];

    MESSAGE_ITEM otemp;
    otemp.setprecision(0);
    otemp << "(fx) Delay enabled; reverb time ";
    otemp << dtime << "ms, surround " << surround;
    otemp << ", number of delays " << dnum << ".";
    ecadebug->msg(0, otemp.to_string());

    dtime = dtime * (double)SAMPLE_BUFFER::sample_rate / 1000;
}

double EFFECT_DELAY::get_parameter(int param) { 
  switch (param) {
  case 1: 
    return(dtime / (double)SAMPLE_BUFFER::sample_rate * 1000.0);
  case 2:
    return(surround);
  case 3:
    return(dnum);
  }
}

void EFFECT_DELAY::process(SAMPLE_BUFFER::sample_type *insample) {

    temp3.make_silent();

    for(nm2 = 0; nm2 < dnum; nm2++) {
        if (laskuri >= dtime * (nm2 + 1)) {
            temp2 = buffer[nm2].front();
            switch ((int)surround) {
                case 0: {
                    temp = *insample;
                    break;
                }
                case 1: {
                    temp2.swap_channels();
                    break;
                }
                case 2: {
                    if (nm2 % 2 == 0) {
                    }
                    else {
                    }
                    break;
                }
            } // switch
            buffer[nm2].pop_front();
        }
        else if (nm2 == 0) {
            insample->put_left(insample->get_left());
            insample->put_right(insample->get_right());
        }
        buffer[nm2].push_back(*insample);
        temp3.put_left( temp3.get_left() + temp.get_left());
        temp3.put_right( temp3.get_right() + temp.get_right());
    }
    laskuri++;
    insample->put_left(temp3.get_left() / dnum);
    insample->put_right(temp3.get_right() / dnum);
}

EFFECT_FAKE_STEREO::EFFECT_FAKE_STEREO (double delay_time) {
    laskuri = 0;
    dtime = delay_time;
    
    buffer = new SINGLE_BUFFER[1];

    if (dtime == 0.0) dtime = 10.0;

    MESSAGE_ITEM mitem;
    mitem << "(fx) Fake-stereo enabled; delay time (ms) " << dtime << ".";
    ecadebug->msg(0, mitem.to_string());

    dtime = dtime * (double)SAMPLE_BUFFER::sample_rate / 1000.0;
}

double EFFECT_FAKE_STEREO::get_parameter(int param) { 
  switch (param) {
  case 1: 
    return(dtime / (double)SAMPLE_BUFFER::sample_rate * 1000.0);
  }
}

void EFFECT_FAKE_STEREO::process(SAMPLE_BUFFER::sample_type *insample) {

    if (laskuri >= dtime) {
        temp = buffer[0].front();
        temp.put_left((insample->get_left() + insample->get_right()) / 2.0);
        temp.put_right((temp.get_left() + temp.get_right()) / 2.0);
        buffer[0].pop_front();
    }
    else {
        temp.put_left(insample->get_left() + insample->get_right() / 2.0);        
        temp.put_right(0.0);
        laskuri++;
    }
    buffer[0].push_back(*insample);
//    insample->mix(temp, emix);
}

EFFECT_REVERB::EFFECT_REVERB (double delay_time, const string& surround_mode, double feedback_percent) {
  // EFFECT_REVERB::EFFECT_REVERB (double delay_time, const string& surround_mode, double feedback_percent) : fbuffer(delay_time * (double)SAMPLE_BUFFER::sample_rate / 1000.0) {
    laskuri = 0.0;

    dtime = delay_time;

    if (surround_mode == "surround") 
      surround = 1;
    else if (surround_mode == "stereo-spread") 
      surround = 2;
    else
      surround = 0;

    feedback = feedback_percent / 100.0;

    buffer = new SINGLE_BUFFER[1];

    if (dtime == 0.0) dtime = 1.0;

    MESSAGE_ITEM otemp;
    otemp.setprecision(0);
    otemp << "(fx) Reverb enabled; reverb time ";
    otemp << dtime << "ms, surround " << surround;
    otemp << ", feedback " << feedback * 100.0 << ".";
    ecadebug->msg(0, otemp.to_string());
    dtime = dtime * (double)SAMPLE_BUFFER::sample_rate / 1000;
}

double EFFECT_REVERB::get_parameter(int param) { 
  switch (param) {
  case 1: 
    return(dtime / (double)SAMPLE_BUFFER::sample_rate * 1000.0);
  case 2:
    return(surround);
  case 3:
    return(feedback * 100.0);
  }
}

void EFFECT_REVERB::process(SAMPLE_BUFFER::sample_type *insample) {

    if (laskuri >= dtime) {
       temp = buffer[0].front();
       //      temp = fbuffer.front();
      if (surround == 0) {
	insample->mix(temp, feedback);
        }
      else {
	temp.swap_channels();
	insample->mix(temp, feedback);
      }
              buffer[0].pop_front();
    }
    else {
      insample->put_left( insample->get_left() * (1.0 - feedback) );
      insample->put_right( insample->get_right() * (1.0 - feedback) );
      laskuri++;
    }
     buffer[0].push_back(*insample);
    //    fbuffer.push_back(*insample);
}

