# ---
# definitions

%define ver     0.4.1
%define pkgver  0.4.1
%define pkgrel  1

# ---
# global settings

Packager: 	Kai Vehmanen <kai.vehmanen@wakkanet.fi>
Distribution: 	www.eca.cx audio software

# allow relocation
Prefix: 	%{_prefix}

# ---
# main package

Name: 		ecamegapedal
Version: 	%{pkgver}
Release: 	%{pkgrel}
Copyright: 	GPL
Source: 	http://ecasound.seul.org/download/ecamegapedal-%{ver}.tar.gz
URL: 		http://www.eca.cx/ecasound
BuildRoot:	/var/tmp/%{name}-%{version}-root-%(id -u -n)

Requires: 	ecasound >= 2.2.0
BuildPreReq: 	ecasound-devel

Summary: ecamegapedal - a realtime effect processor
Group: X11/Applications/Sound

%description
Ecamegapedal is a realtime effect processor built on top 
of ecasound and Qt packages. It's meant to be used as 
a virtual guitar-fx or studio effect box. In addition to 
realtime operation, ecamegapedal also supports reading from
and writing to audio files. All audio file formats and effect 
algorithms provided by the ecasound libraries are supported. 
This includes JACK, ALSA, OSS, aRts, over 20 file formats, 
over 30 effect types, LADSPA plugins and multi-operator effect 
presets.

%prep
%setup -n ecamegapedal-0.4.1
%build
./configure --prefix=%prefix  --mandir=%{_mandir} --disable-static $extra_params
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
make DESTDIR="$RPM_BUILD_ROOT" install-strip

# ---
# cleanup after build

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

# ---
# files sections (main)

%files
%defattr(-, root, root)
%doc NEWS COPYING README INSTALL
%doc Documentation/ecamegapedal_manpage.html
%{_mandir}/man1/eca*
%{_bindir}/ecamegapedal
%{_datadir}/ecamegapedal

%changelog
* Tue Jan 21 2003 Kai Vehmanen <kai.vehmanen@wakkanet.fi>
- Added the button pixmaps to the file list.

* Fri Jan 17 2003 Kai Vehmanen <kai.vehmanen@wakkanet.fi>
- Rewrite the spec file to match the style used in 
  ecasound-2.2.0's spec-file.

* Thu Oct 17 2002 Kai Vehmanen <kai.vehmanen@wakkanet.fi>
- Added BuildPreReq tag.

* Sun Jun 17 2001 Kai Vehmanen <kaiv@wakkanet.fi>
- Initial release. Before this release ecamegapedal was
  part of qtecasound distribution.
