#ifndef _QEOPERATORCONFIGURATION_H
#define _QEOPERATORCONFIGURATION_H

#include <vector>

#include <qwidget.h>
#include <qhbox.h>
#include <qlineedit.h>

#include <ecasound/eca-operator.h>

#include "qeinput.h"

class QLabel;
class QLineEdit;
class QGroupBox;
class QGrid;
class QSlider;
class OPERATOR::PARAM_DESCRIPTION;

/**
 * Input widget for configuring ecasound operators
 */
class QEOperatorConfiguration : public QEInput {
  Q_OBJECT
 public:

  QEOperatorConfiguration (OPERATOR* op, QWidget *parent = 0, const char *name = 0);
  ~QEOperatorConfiguration (void);

  /**
   * Returns the resulting operator object instance
   */
  OPERATOR* result(void) const { return(operator_repp); }

  bool eventFilter(QObject *, QEvent *e);

public slots:

  virtual void update_results(void);
  void change_operator(OPERATOR* op);

private slots:

  void parameter_change_event(void);
  void range_change_event(void);
  void slider_change_event(int n);

signals:

  void parameters_changed(void);

 private:

  OPERATOR* operator_repp;
  vector<QLabel*> paramlist_rep;
  vector<OPERATOR::PARAM_DESCRIPTION*> pardesclist_rep;
  vector<QLineEdit*> inputlist_rep;
  vector<QSlider*> sliderlist_rep;
  vector<int> slidervalues_rep;
  vector<QLineEdit*> lowlimitlist_rep;
  vector<QLineEdit*> highlimitlist_rep;
  vector<QLabel*> suggestlist_rep;

  QGrid* paramgrid_repp;
  QLabel* obj_desc_repp;
  QLabel* obj_name_repp;

  static const int integer_steps_const = 100;

  void init_layout(void);
  void set_from_parameter_desc(int n, bool create);
  void set_range_values(void);
  void set_sliders(void);
};

#endif
