// ------------------------------------------------------------------------
// ecawave.cpp: Ecawave initialization and startup routines.
// Copyright (C) 1999-2001 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <iostream>
#include <signal.h>

#include <qapplication.h>

#include <kvutils/com_line.h>
#include <ecasound/eca-error.h>
#include <ecasound/eca-debug.h>
#include <ecasound/eca-version.h>

#include "version.h"
#include "ecawave.h"
#include "qeinterface.h"
#include "qesession.h"

using std::string;

void signal_handler(int signum);

int main(int argc, char **argv) {
  struct sigaction es_handler;
  es_handler.sa_handler = signal_handler;
  sigemptyset(&es_handler.sa_mask);
  es_handler.sa_flags = 0;

  sigaction(SIGTERM, &es_handler, 0);
  sigaction(SIGINT, &es_handler, 0);
  sigaction(SIGQUIT, &es_handler, 0);
  sigaction(SIGABRT, &es_handler, 0);

  ecadebug->set_debug_level(0x00);
  //  ecadebug->set_debug_level(ECA_DEBUG::info | ECA_DEBUG::module_flow | ECA_DEBUG::user_objects);

  try {
    COMMAND_LINE cline = COMMAND_LINE (argc, argv);
    parse_command_line(cline);

    QApplication qapp (argc, argv);
    string param;
    if (argc > 1) param = string(argv[1]);
    QEInterface ewinterface (param);
    qapp.setMainWidget(&ewinterface);
    ewinterface.show();
    
    QObject::connect( &qapp, SIGNAL( lastWindowClosed() ), &qapp, SLOT( quit() ) );
    return(qapp.exec());
  }
  catch(ECA_ERROR& e) { 
    cerr << "---\nlibecasound error while processing event: [" << e.error_section() << "] : \"" << e.error_message() << "\"\n\n";
  }
  catch(...) {
    cerr << "---\nCaught an unknown exception!\n";
  }
}

void signal_handler(int signum) {
  cerr << "(ecawave) <-- Caught a signal... cleaning up." << endl << endl;
  exit(0);
}

void parse_command_line(COMMAND_LINE& cline) {
  cline.begin();
  while(cline.end() == false) {
    if (cline.current() == "--version") {
      cout << "ecawave "
	   << ecawave_version
	   << " - [libecasound "
	   << ecasound_library_version
	   << "]" << endl;
      cout << "Copyright (C) 1999-2001 Kai Vehmanen" << endl;
      cout << "Ecawave comes with ABSOLUTELY NO WARRANTY." << endl;
      cout << "You may redistribute copies of ecawave under the terms of the GNU" << endl;
      cout << "General Public License. For more information about these matters, see" << endl; 
      cout << "the file named COPYING." << endl;
      exit(0);
    }
    else if (cline.current() == "--help") {
	cout << "USAGE: ecawave [options] filename\n" 
	     << "    --version   print version info" << endl
	     << "    --help      show this help" << endl << endl;
	cout << "For a more detailed documentation, see ecawave(1) man  page." << endl;
	cout << "Report bugs to <k@eca.cx>." << endl;
	exit(0);
      }
    cline.next();
  }
}
 
