#ifndef INCLUDED_QEOPERATORCONFIGURATION_H
#define INCLUDED_QEOPERATORCONFIGURATION_H

#include <vector>

#include <qwidget.h>
#include <qhbox.h>
#include <qlineedit.h>

#include <ecasound/eca-operator.h>

#include "qeinput.h"

class QLabel;
class QLineEdit;
class QGroupBox;
class QGrid;
class QSlider;
class OPERATOR::PARAM_DESCRIPTION;

/**
 * Input widget for configuring ecasound operators
 */
class QEOperatorConfiguration : public QEInput {
  Q_OBJECT
 public:

  QEOperatorConfiguration (OPERATOR* op, QWidget *parent = 0, const char *name = 0);
  ~QEOperatorConfiguration (void);

  /**
   * Returns the resulting operator object instance
   */
  OPERATOR* result(void) const { return(operator_repp); }

  bool eventFilter(QObject *, QEvent *e);

public slots:

  virtual void update_results(void);
  void change_operator(OPERATOR* op);

private slots:

  void parameter_change_event(void);
  void range_change_event(void);
  void slider_change_event(int n);

signals:

  void parameters_changed(void);

 private:

  OPERATOR* operator_repp;
  std::vector<QLabel*> paramlist_rep;
  std::vector<OPERATOR::PARAM_DESCRIPTION*> pardesclist_rep;
  std::vector<QLineEdit*> inputlist_rep;
  std::vector<QSlider*> sliderlist_rep;
  std::vector<int> slidervalues_rep;
  std::vector<QLineEdit*> lowlimitlist_rep;
  std::vector<QLineEdit*> highlimitlist_rep;
  std::vector<QLabel*> suggestlist_rep;

  QGrid* paramgrid_repp;
  QLabel* obj_desc_repp;
  QLabel* obj_name_repp;

  static const int integer_steps_const = 100;

  void init_layout(void);
  void set_from_parameter_desc(int n, bool create);
  void set_range_values(void);
  void set_sliders(void);
};

#endif
