#ifndef INCLUDED_QECHAINOPERATORINPUT_H
#define INCLUDED_QECHAINOPERATORINPUT_H

#include <vector>

#include <qwidget.h>
#include <qhbox.h>
#include <qlineedit.h>

#include <ecasound/eca-static-object-maps.h>
#include <ecasound/eca-chainop.h>

#include "qeinput.h"

class QLabel;
class QTabWidget;
class QEObjectMap;
class QEOperatorConfiguration;

/**
 * Null chain operator.
 */
class QEEmptyChainOperator : public CHAIN_OPERATOR {

 public:

  virtual std::string name(void) const { return("<none>"); }
  virtual std::string parameter_names(void) const  { return(""); }
  virtual void set_parameter(int param, parameter_type value) { }
  virtual parameter_type get_parameter(int param) const { return(0.0f); }
  virtual void init(SAMPLE_BUFFER *insample) { }
  virtual void process(void) { }

  QEEmptyChainOperator* clone(void)  { return new QEEmptyChainOperator(*this); }
  QEEmptyChainOperator* new_expr(void)  { return new QEEmptyChainOperator(); }
};

/**
 * Chain operator input widget
 */
class QEChainOperatorInput : public QEInput {
  Q_OBJECT
 public:

  QEChainOperatorInput (QWidget *parent = 0, const char *name = 0);
  ~QEChainOperatorInput (void);

  /**
   * Returns the resulting chain operator object instance
   */
  CHAIN_OPERATOR* result(void) const { return(chainop_repp); }

public slots:

  virtual void update_results(void);

private slots:

 void parameter_change_event(void); 
 void operator_change_event(void); 

signals:

  void parameters_changed(void);
  void operator_changed(void);

 private:

  CHAIN_OPERATOR* chainop_repp;
  CHAIN_OPERATOR* default_chainop_repp;
  QEOperatorConfiguration* opconf_repp;
  QTabWidget* maptab_rep;
  std::vector<QEObjectMap*> omap_inputs;
  QLabel* cop_desc;
  std::vector<QLabel*> paramlist;
  std::vector<QLineEdit*> inputlist; 

  /**
   * Creates and initializes widget layout
   */
  void init_layout(void);
};

#endif
