#ifndef INCLUDED_QEAUDIOTRAP_H
#define INCLUDED_QEAUDIOTRAP_H

#include <string>
#include <ecasound/eca-chainop.h>

class QEVUMeter;

/**
 * Audio trap object is inserted to a ecasound
 * engine instance. When engine delivers a new 
 * block of audio to the trap object, it calls
 * the dataUpdated() callback.
 *
 * @author Kai Vehmanen
 */
class QEAudioTrap : public CHAIN_OPERATOR
{

public: 
  QEAudioTrap(QObject *parent=0, const char *name=0, QEVUMeter* target = 0);
  ~QEAudioTrap(void);

  virtual std::string name(void) const { return("Audio trap"); }

  virtual void init(SAMPLE_BUFFER* sbuf);
  virtual void process(void);

  virtual std::string parameter_names(void) const { return(""); }
  virtual CHAIN_OPERATOR::parameter_type get_parameter(int param) const { return(0.0f); }
  virtual void set_parameter(int param, CHAIN_OPERATOR::parameter_type value) { }
  
  OPERATOR* clone(void)  { return new QEAudioTrap(); }
  OPERATOR* new_expr(void)  { return new QEAudioTrap(); }
	
private:

  long int sample_processing_step;
  SAMPLE_BUFFER* buffer_repp;
  int channels_rep;
  QEVUMeter* vumeter_target_repp;
};

#endif
